% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_md_table_example.R
\name{read_md_table_example}
\alias{read_md_table_example}
\title{Get Path to readMDTable Examples}
\usage{
read_md_table_example(file = NULL)
}
\arguments{
\item{file}{Name of file. If \code{NULL}, the example files will be listed.}
}
\value{
Vector of example file names if \code{file} is \code{NULL}, else the path
to the example markdown table file.
}
\description{
Get Path to readMDTable Examples
}
\details{
readMDTable comes with a number of well-known
datasets as example markdown tables in the \code{inst/extdata}
directory. \code{read_md_table_example} will list the file
names or return the path of a specified file.
}
\examples{
# List the available example files
read_md_table_example()

# Get the path to the mtcars example file
read_md_table_example("mtcars.md")

# Read in an example file
mtcars_path <- read_md_table_example("mtcars.md")
read_md_table(mtcars_path)
}
