% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fwf.R
\name{read_fwf}
\alias{fwf_empty}
\alias{fwf_positions}
\alias{fwf_widths}
\alias{read_fwf}
\title{Read a fixed width file.}
\usage{
read_fwf(file, col_positions, col_types = NULL, locale = default_locale(),
  na = c("", "NA"), comment = "", skip = 0, n_max = Inf,
  guess_max = min(n_max, 1000), progress = interactive())

fwf_empty(file, skip = 0, col_names = NULL, comment = "")

fwf_widths(widths, col_names = NULL)

fwf_positions(start, end, col_names = NULL)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
   (either a single string or a raw vector).

   Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
   be automatically uncompressed. Files starting with \code{http://},
   \code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
   downloaded. Remote gz files can also be automatically downloaded &
   decompressed.

   Literal data is most useful for examples and tests. It must contain at
   least one new line to be recognised as data (instead of a path).}

\item{col_positions}{Column positions, as created by \code{fwf_empty},
\code{fwf_widths} or \code{fwf_positions}. To read in only selected fields,
use \code{fwf_positions}. If the width of the last column is variable (a
ragged fwf file), supply the last end position as NA.}

\item{col_types}{One of \code{NULL}, a \code{\link{cols}} specification, or
  a string. See \code{vignette("column-types")} for more details.

  If \code{NULL}, all column types will be imputed from the first 1000 rows
  on the input. This is convenient (and fast), but not robust. If the
  imputation fails, you'll need to supply the correct types yourself.

  If a column specification created by \code{\link{cols}}, it must contain
  one column specification for each column. If you only want to read a
  subset of the columns, use \code{\link{cols_only}}.

  Alternatively, you can use a compact string representation where each
  character represents one column:
  c = character, i = integer, n = number, d = double,
  l = logical, D = date, T = date time, t = time, ? = guess, or
  \code{_}/\code{-} to skip the column.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link{locale}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{na}{Character vector of strings to use for missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{comment}{A string used to identify comments. Any text after the
comment characters will be silently ignored.}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Maximum number of records to read.}

\item{guess_max}{Maximum number of records to use for guessing column types.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session. The display is updated every 50,000 values
and will only display if estimated reading time is 5 seconds or more.}

\item{col_names}{Either NULL, or a character vector column names.}

\item{widths}{Width of each field. Use NA as width of last field when
reading a ragged fwf file.}

\item{start, end}{Starting and ending (inclusive) positions of each field.
Use NA as last end field when reading a ragged fwf file.}
}
\description{
A fixed width file can be a very compact representation of numeric data.
It's also very fast to parse, because every field is in the same place in
every line. Unfortunately, it's painful to parse because you need to
describe the length of every field. Readr aims to make it as easy as possible
by providing a number of different ways to describe the field structure.
}
\examples{
fwf_sample <- readr_example("fwf-sample.txt")
cat(read_lines(fwf_sample))

# You can specify column positions in three ways:
# 1. Guess based on position of empty columns
read_fwf(fwf_sample, fwf_empty(fwf_sample, col_names = c("first", "last", "state", "ssn")))
# 2. A vector of field widths
read_fwf(fwf_sample, fwf_widths(c(20, 10, 12), c("name", "state", "ssn")))
# 3. Paired vectors of start and end positions
read_fwf(fwf_sample, fwf_positions(c(1, 30), c(10, 42), c("name", "ssn")))
}
\seealso{
\code{\link{read_table}} to read fixed width files where each
  column is separated by whitespace.
}

