% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_delim.R
\name{spec_delim}
\alias{spec_csv}
\alias{spec_csv2}
\alias{spec_delim}
\alias{spec_tsv}
\title{Retrieve the column specification of a file.}
\usage{
spec_delim(file, delim, quote = "\\"", escape_backslash = FALSE,
  escape_double = TRUE, col_names = TRUE, col_types = NULL,
  locale = default_locale(), na = c("", "NA"), quoted_na = TRUE,
  comment = "", trim_ws = FALSE, skip = 0, n_max = 0,
  guess_max = 1000, progress = interactive())

spec_csv(file, col_names = TRUE, col_types = NULL,
  locale = default_locale(), na = c("", "NA"), quoted_na = TRUE,
  comment = "", trim_ws = TRUE, skip = 0, n_max = 0, guess_max = 1000,
  progress = interactive())

spec_csv2(file, col_names = TRUE, col_types = NULL,
  locale = default_locale(), na = c("", "NA"), quoted_na = TRUE,
  comment = "", trim_ws = TRUE, skip = 0, n_max = 0, guess_max = 1000,
  progress = interactive())

spec_tsv(file, col_names = TRUE, col_types = NULL,
  locale = default_locale(), na = c("", "NA"), quoted_na = TRUE,
  comment = "", trim_ws = TRUE, skip = 0, n_max = 0, guess_max = 1000,
  progress = interactive())
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
   (either a single string or a raw vector).

   Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
   be automatically uncompressed. Files starting with \code{http://},
   \code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
   downloaded. Remote gz files can also be automatically downloaded &
   decompressed.

   Literal data is most useful for examples and tests. It must contain at
   least one new line to be recognised as data (instead of a path).}

\item{delim}{Single character used to separate fields within a record.}

\item{quote}{Single character used to quote strings.}

\item{escape_backslash}{Does the file use backslashes to escape special
characters? This is more general than \code{escape_double} as backslashes
can be used to escape the delimeter character, the quote characer, or
to add special characters like \code{\\n}.}

\item{escape_double}{Does the file escape quotes by doubling them?
i.e. If this option is \code{TRUE}, the value \code{""""} represents
a single quote, \code{\"}.}

\item{col_names}{Either \code{TRUE}, \code{FALSE} or a character vector
  of column names.

  If \code{TRUE}, the first row of the input will be used as the column
  names, and will not be included in the data frame. If \code{FALSE}, column
  names will be generated automatically: X1, X2, X3 etc.

  If \code{col_names} is a character vector, the values will be used as the
  names of the columns, and the first row of the input will be read into
  the first row of the output data frame.

  Missing (\code{NA}) column names will generate a warning, and be filled
  in with dummy names \code{X1}, \code{X2} etc. Duplicate column names
  will generate a warning and be made unique with a numeric prefix.}

\item{col_types}{One of \code{NULL}, a \code{\link{cols}} specification, or
  a string. See \code{vignette("column-types")} for more details.

  If \code{NULL}, all column types will be imputed from the first 1000 rows
  on the input. This is convenient (and fast), but not robust. If the
  imputation fails, you'll need to supply the correct types yourself.

  If a column specification created by \code{\link{cols}}, it must contain
  one column specification for each column. If you only want to read a
  subset of the columns, use \code{\link{cols_only}}.

  Alternatively, you can use a compact string representation where each
  character represents one column:
  c = character, i = integer, n = number, d = double,
  l = logical, D = date, T = date time, t = time, ? = guess, or
  \code{_}/\code{-} to skip the column.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link{locale}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{na}{Character vector of strings to use for missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{quoted_na}{Should missing values inside quotes be treated as missing
values (the default) or strings.}

\item{comment}{A string used to identify comments. Any text after the
comment characters will be silently ignored.}

\item{trim_ws}{Should leading and trailing whitespace be trimmed from
each field before parsing it?}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Maximum number of records to read.}

\item{guess_max}{Maximum number of records to use for guessing column types.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session. The display is updated every 50,000 values
and will only display if estimated reading time is 5 seconds or more.}
}
\value{
The \code{col_spec} generated for the file.
}
\description{
By default the types of the first 20 columns are printed,
\code{options(readr.num_columns)} can be used to modify this (a value of 0
turns off printing).
}
\examples{
# Input sources -------------------------------------------------------------
# Retrieve specs from a path
spec_csv(system.file("extdata/mtcars.csv", package = "readr"))
spec_csv(system.file("extdata/mtcars.csv.zip", package = "readr"))

# Or directly from a string (must contain a newline)
spec_csv("x,y\\n1,2\\n3,4")

# Column types --------------------------------------------------------------
# By default, readr guess the columns types, looking at the first 1000 rows.
# You can specify the number of rows used with guess_max.
spec_csv(system.file("extdata/mtcars.csv", package = "readr"), guess_max = 20)
}

