% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problems.R
\name{problems}
\alias{problems}
\alias{stop_for_problems}
\title{Retrieve parsing problems}
\usage{
problems(x)

stop_for_problems(x)
}
\arguments{
\item{x}{An data frame (from \code{read_*()}) or a vector
(from \code{parse_*()}).}
}
\value{
A data frame with one row for each problem and four columns:
\item{row,col}{Row and column of problem}
\item{expected}{What readr expected to find}
\item{actual}{What it actually got}
}
\description{
Readr functions will only throw an error if parsing fails in an unrecoverable
way. However, there are lots of potential problems that you might want to
know about - these are stored in the \code{problems} attribute of the
output, which you can easily access with this function.
\code{stop_for_problems()} will throw an error if there are any parsing
problems: this is useful for automated scripts where you want to throw
an error as soon as you encounter a problem.
}
\examples{
x <- parse_integer(c("1X", "blah", "3"))
problems(x)

y <- parse_integer(c("1", "2", "3"))
problems(y)
}
