% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_utils.R
\name{extract_timeseries_var}
\alias{extract_timeseries_var}
\title{Extract the values over time of a variable from a Stan fit}
\usage{
extract_timeseries_var(var_name, posterior_df)
}
\arguments{
\item{var_name}{A string that indicates the variable's name for which the
function will construct the timeseries.}

\item{posterior_df}{A Stan fit object converted into a data frame}
}
\value{
A data frame
}
\description{
Extract the values over time of a variable from a Stan fit
}
\examples{
posterior_df <- data.frame(`var[1]` = rep(0, 2), `var[2]` = rep(1, 2),
                            check.names = FALSE)
extract_timeseries_var("var", posterior_df)
}
