% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_xmile.R
\name{xmile_to_deSolve}
\alias{xmile_to_deSolve}
\title{Parse XMILE to deSolve components}
\usage{
xmile_to_deSolve(filepath)
}
\arguments{
\item{filepath}{A string that indicates a path to a file with extension .stmx
or .xmile. Vensim files (.mdl) are not xmile files. They must be exported
from Vensim with extension .xmile}
}
\value{
This function returns a list with at least four elements.
\emph{stocks}, a numeric vector that contains initial values. \emph{consts},
a numeric vector with the model's constants. \emph{func}, the function that
wraps the model's equations. \emph{sim_params}, a list with control
parameters. If the model includes a table or graphical function, this
function returns the element \emph{graph_funs}, a list with these functions.
}
\description{
\code{xmile_to_deSolve} returns a list that serves as an input for
deSolve's ODE function.
}
\details{
This function extracts the xml from the file specified via \code{filepath}
to generate a list with the necessary elements to simulate with
\link[deSolve]{deSolve}.
}
\examples{
path <- system.file("models", "SIR.stmx", package = "readsdr")
xmile_to_deSolve(path)
}
