library(rearrr)
context("roll_values()")

test_that("examples in roll_values()", {

  ## Testing 'roll_values(c(0:360), add = 90)'                              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- roll_values(c(0:360), add = 90)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_19148[["Value"]], n = 30),
    c(27, 40, 47, 88, 102, 130, 148, 160, 162, 172, 184, 191, 229, 231,
      248, 251, 261, 277, 297, 302, 308, 319, 325, 326, 330, 335,
      337, 350, 353, 359),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["Value_rolled"]], n = 30),
    c(117, 130, 137, 178, 192, 220, 238, 250, 252, 262, 274, 281, 319,
      321, 338, 341, 351, 7, 27, 32, 38, 49, 55, 56, 60, 65, 67, 80,
      83, 89),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[[".range_str"]], n = 30),
    c("Value=[0,360)", "Value=[0,360)", "Value=[0,360)", "Value=[0,360)",
      "Value=[0,360)", "Value=[0,360)", "Value=[0,360)", "Value=[0,360)",
      "Value=[0,360)", "Value=[0,360)", "Value=[0,360)", "Value=[0,360)",
      "Value=[0,360)", "Value=[0,360)", "Value=[0,360)", "Value=[0,360)",
      "Value=[0,360)", "Value=[0,360)", "Value=[0,360)", "Value=[0,360)",
      "Value=[0,360)", "Value=[0,360)", "Value=[0,360)", "Value=[0,360)",
      "Value=[0,360)", "Value=[0,360)", "Value=[0,360)", "Value=[0,360)",
      "Value=[0,360)", "Value=[0,360)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("Value", "Value_rolled", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(361L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'roll_values(c(0:360), add = 90)'                     ####



  ## Testing 'roll_values_vec(c(0:360), add = 90)'                          ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- roll_values_vec(c(0:360), add = 90)
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    xpectr::smpl(output_19148, n = 30),
    c(117, 130, 137, 178, 192, 220, 238, 250, 252, 262, 274, 281, 319,
      321, 338, 341, 351, 7, 27, 32, 38, 49, 55, 56, 60, 65, 67, 80,
      83, 89),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(xpectr::smpl(output_19148, n = 30)),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    361L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    361L)
  ## Finished testing 'roll_values_vec(c(0:360), add = 90)'                 ####



  ## Testing 'roll_values(c(0:360), .min = 0, .max = 180)'                  ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- roll_values(c(0:360), .min = 0, .max = 180)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_19148[["Value"]], n = 30),
    c(27, 40, 47, 88, 102, 130, 148, 160, 162, 172, 184, 191, 229, 231,
      248, 251, 261, 277, 297, 302, 308, 319, 325, 326, 330, 335,
      337, 350, 353, 359),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[["Value_rolled"]], n = 30),
    c(27, 40, 47, 88, 102, 130, 148, 160, 162, 172, 4, 11, 49, 51, 68,
      71, 81, 97, 117, 122, 128, 139, 145, 146, 150, 155, 157, 170,
      173, 179),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19148[[".range_str"]], n = 30),
    c("Value=[0,180)", "Value=[0,180)", "Value=[0,180)", "Value=[0,180)",
      "Value=[0,180)", "Value=[0,180)", "Value=[0,180)", "Value=[0,180)",
      "Value=[0,180)", "Value=[0,180)", "Value=[0,180)", "Value=[0,180)",
      "Value=[0,180)", "Value=[0,180)", "Value=[0,180)", "Value=[0,180)",
      "Value=[0,180)", "Value=[0,180)", "Value=[0,180)", "Value=[0,180)",
      "Value=[0,180)", "Value=[0,180)", "Value=[0,180)", "Value=[0,180)",
      "Value=[0,180)", "Value=[0,180)", "Value=[0,180)", "Value=[0,180)",
      "Value=[0,180)", "Value=[0,180)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("Value", "Value_rolled", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(361L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'roll_values(c(0:360), .min = 0, .max = 180)'         ####

  x <- c(1:7)
  x <- x ^ 2

  ## Testing 'wrap_to_range(x, .min = 1, .max = 7)'                         ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- wrap_to_range(x, .min = 1, .max = 7)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["Value"]],
    c(1, 4, 9, 16, 25, 36, 49),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["Value_wrapped"]],
    c(1, 4, 3, 4, 1, 6, 1),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".range_str"]],
    c("Value=[1,7)", "Value=[1,7)", "Value=[1,7)", "Value=[1,7)", "Value=[1,7)",
      "Value=[1,7)", "Value=[1,7)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("Value", "Value_wrapped", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(7L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'wrap_to_range(x, .min = 1, .max = 7)'                ####


  ## Testing 'wrap_to_range(x, .min = 1, .max = 7, between...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- wrap_to_range(x, .min = 1, .max = 7, between = 1)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["Value"]],
    c(1, 4, 9, 16, 25, 36, 49),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["Value_wrapped"]],
    c(1, 4, 2, 2, 4, 1, 7),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".range_str"]],
    c("Value=[1,7]", "Value=[1,7]", "Value=[1,7]", "Value=[1,7]", "Value=[1,7]",
      "Value=[1,7]", "Value=[1,7]"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("Value", "Value_wrapped", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(7L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'wrap_to_range(x, .min = 1, .max = 7, between...'     ####


  ## Testing 'wrap_to_range_vec(x, .min = 1, .max = 7, bet...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- wrap_to_range_vec(x, .min = 1, .max = 7, between = 1)
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(1, 4, 2, 2, 4, 1, 7),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    7L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    7L)
  ## Finished testing 'wrap_to_range_vec(x, .min = 1, .max = 7, bet...'     ####

  # On data frame

  df <- data.frame(
    "w" = 1:7,
    "d" = c(0, 45, 90, 135, 180, 270, 360)
  )


  ## Testing 'roll_values( df, cols = "w", add = 1, .min =...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- roll_values(df, cols = "w", add = 1, .min = 1, .max = 7, between = 1)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["w"]],
    c(1, 2, 3, 4, 5, 6, 7),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["d"]],
    c(0, 45, 90, 135, 180, 270, 360),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["w_rolled"]],
    c(2, 3, 4, 5, 6, 7, 1),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".range_str"]],
    c("w=[1,7]", "w=[1,7]", "w=[1,7]", "w=[1,7]", "w=[1,7]", "w=[1,7]",
      "w=[1,7]"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("w", "d", "w_rolled", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(7L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'roll_values( df, cols = "w", add = 1, .min =...'     ####


  ## Testing 'roll_values(df, cols = "d", add = -90, .min ...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- roll_values(df, cols = "d", add = -90, .min = 0, .max = 360, between = 0)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["w"]],
    c(1, 2, 3, 4, 5, 6, 7),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["d"]],
    c(0, 45, 90, 135, 180, 270, 360),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["d_rolled"]],
    c(270, 315, 0, 45, 90, 180, 270),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".range_str"]],
    c("d=[0,360)", "d=[0,360)", "d=[0,360)", "d=[0,360)", "d=[0,360)",
      "d=[0,360)", "d=[0,360)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("w", "d", "d_rolled", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(7L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'roll_values(df, cols = "d", add = -90, .min ...'     ####


  ## Testing 'roll_values(df, cols = c("w", "d"), add = 1)'                 ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- roll_values(df, cols = c("w", "d"), add = 1)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["w"]],
    c(1, 2, 3, 4, 5, 6, 7),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["d"]],
    c(0, 45, 90, 135, 180, 270, 360),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["w_rolled"]],
    c(2, 3, 4, 5, 6, 1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["d_rolled"]],
    c(1, 46, 91, 136, 181, 271, 1),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".range_str"]],
    c("w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)",
      "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)",
      "w=[1,7),d=[0,360)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("w", "d", "w_rolled", "d_rolled", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    7:6)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'roll_values(df, cols = c("w", "d"), add = 1)'        ####


  ## Testing 'wrap_to_range(df, cols = "w", .min = 2, .max...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- wrap_to_range(df, cols = "w", .min = 2, .max = 5, between = 1)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["w"]],
    c(1, 2, 3, 4, 5, 6, 7),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["d"]],
    c(0, 45, 90, 135, 180, 270, 360),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["w_wrapped"]],
    c(5, 2, 3, 4, 5, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".range_str"]],
    c("w=[2,5]", "w=[2,5]", "w=[2,5]", "w=[2,5]", "w=[2,5]", "w=[2,5]",
      "w=[2,5]"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("w", "d", "w_wrapped", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(7L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'wrap_to_range(df, cols = "w", .min = 2, .max...'     ####


})

test_that("fuzz testing roll_values()", {
  xpectr::set_test_seed(42)

  df <- data.frame(
    "w" = 1:7,
    "d" = c(0, 45, 90, 135, 180, 270, 360),
    "ch" = LETTERS[1:7],
    "g" = c(1,1,2,2,3,3,3),
    stringsAsFactors = FALSE
  )

  # Generate expectations for 'roll_values'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = roll_values,
  #   args_values = list(
  #     "data" = list(df, dplyr::group_by(df, g), c(1:5), c("h", "e", "j"), NA),
  #     "cols" = list(c("w", "d"), "w", "d", "ch", "hej", 1, NA),
  #     "add" = list(2, -2, c(-2, 2), 0, "hej", NA),
  #     ".min" = list(NULL, 20, -10, "h", NA),
  #     ".max" = list(NULL, 30, -10, NA),
  #     "between" = list(0, 1, -1, "h", NA),
  #     "na.rm" = list(FALSE, TRUE, NA),
  #     "suffix" = list("","_rolled", 1, NA),
  #     "keep_original" = list(FALSE, TRUE, 1, NA),
  #     "range_col_name" = list(".range", ".r", 1, NA),
  #     "overwrite" = list(TRUE, FALSE)
  #   ),
  #   extra_combinations = list(
  #     list("data" = c(1:5), "cols" = NULL, "add" = 1, ".min" = 2),
  #     list("data" = c(1:5, NA), "cols" = NULL, "add" = 1, na.rm = FALSE),
  #     list("data" = c(1:5, NA), "cols" = NULL, "add" = 1, na.rm = TRUE),
  #     list("overwrite" = FALSE, "range_col_name" = "g")
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'roll_values'                                                    ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["w"]],
    c(3, 4, 5, 6, 1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["d"]],
    c(2, 47, 92, 137, 182, 272, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".range_str"]],
    c("w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)",
      "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)",
      "w=[1,7),d=[0,360)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("w", "d", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(7L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing roll_values(data = dplyr::group_by(df, g), c...
  # Changed from baseline: data = dplyr::group_b...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- roll_values(data = dplyr::group_by(df, g), cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19370),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19370[["g"]],
    c(1, 1, 2, 2, 3, 3, 3),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["w"]],
    c(1, 1, 3, 3, 5, 6, 5),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["d"]],
    c(2, 2, 92, 92, 182, 272, 182),
    tolerance = 1e-4)
  expect_equal(
    output_19370[[".range_str"]],
    c("w=[1,2),d=[0,45)", "w=[1,2),d=[0,45)", "w=[3,4),d=[90,135)",
      "w=[3,4),d=[90,135)", "w=[5,7),d=[180,360)", "w=[5,7),d=[180,360)",
      "w=[5,7),d=[180,360)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19370),
    c("g", "w", "d", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19370),
    c("numeric", "numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19370),
    c("double", "double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    c(7L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19370)),
    character(0),
    fixed = TRUE)

  # Testing roll_values(data = c(1:5), cols = c("w", "d"...
  # Changed from baseline: data = c(1:5)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(roll_values(data = c(1:5), cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'cols' should be NULL."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = c("h", "e", "j"), cols = ...
  # Changed from baseline: data = c("h", "e", "j")
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(roll_values(data = c("h", "e", "j"), cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'cols' should be NULL."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = NA, cols = c("w", "d"), a...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(roll_values(data = NA, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'cols' should be NULL."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = NULL, cols = c("w", "d"),...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(roll_values(data = NULL, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'cols' should be NULL."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = c(1:5), cols = NULL, add ...
  # Changed from baseline: data, cols, add, .min
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- roll_values(data = c(1:5), cols = NULL, add = 1, .min = 2, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17365),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17365[["Value"]],
    c(2, 3, 4, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    output_17365[[".range_str"]],
    c("Value=[2,5)", "Value=[2,5)", "Value=[2,5)", "Value=[2,5)", "Value=[2,5)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_17365),
    c("Value", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(5L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing roll_values(data = c(1:5, NA), cols = NULL, ...
  # Changed from baseline: data, cols, add, na.rm
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(roll_values(data = c(1:5, NA), cols = NULL, add = 1, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'integer'\n * checkmate::check_vector(data): Contains missing values (element 6)\n * checkmate::check_factor(data): Must be of type 'factor', not 'integer'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = c(1:5, NA), cols = NULL, ...
  # Changed from baseline: data, cols, add, na.rm
  xpectr::set_test_seed(42)
  # Assigning output
  output_16569 <- roll_values(data = c(1:5, NA), cols = NULL, add = 1, .min = NULL, .max = NULL, between = 0, na.rm = TRUE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_16569),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16569[["Value"]],
    c(2, 3, 4, 1, 2, NA),
    tolerance = 1e-4)
  expect_equal(
    output_16569[[".range_str"]],
    c("Value=[1,5)", "Value=[1,5)", "Value=[1,5)", "Value=[1,5)", "Value=[1,5)",
      "Value=[1,5)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_16569),
    c("Value", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16569),
    c("numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16569),
    c("double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16569),
    c(6L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16569)),
    character(0),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = NA, add = 2, ....
  # Changed from baseline: cols = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(roll_values(data = df, cols = NA, add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("Assertion on 'specified column names (NA, \".range\")' failed: Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = "w", add = 2, ...
  # Changed from baseline: cols = "w"
  xpectr::set_test_seed(42)
  # Assigning output
  output_14577 <- roll_values(data = df, cols = "w", add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14577),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14577[["w"]],
    c(3, 4, 5, 6, 1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    output_14577[[".range_str"]],
    c("w=[1,7)", "w=[1,7)", "w=[1,7)", "w=[1,7)", "w=[1,7)", "w=[1,7)",
      "w=[1,7)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_14577),
    c("w", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14577),
    c("numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14577),
    c("double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14577),
    c(7L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14577)),
    character(0),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = "d", add = 2, ...
  # Changed from baseline: cols = "d"
  xpectr::set_test_seed(42)
  # Assigning output
  output_17191 <- roll_values(data = df, cols = "d", add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17191),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17191[["d"]],
    c(2, 47, 92, 137, 182, 272, 2),
    tolerance = 1e-4)
  expect_equal(
    output_17191[[".range_str"]],
    c("d=[0,360)", "d=[0,360)", "d=[0,360)", "d=[0,360)", "d=[0,360)",
      "d=[0,360)", "d=[0,360)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_17191),
    c("d", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17191),
    c("numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17191),
    c("double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17191),
    c(7L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17191)),
    character(0),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = "ch", add = 2,...
  # Changed from baseline: cols = "ch"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(roll_values(data = df, cols = "ch", add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable ''cols' columns': May only contain the following types: {numeric}, but element 1 has type\n * 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = "hej", add = 2...
  # Changed from baseline: cols = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(roll_values(data = df, cols = "hej", add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * These names in the 'col(s)' argument were not found in 'data': hej."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = 1, add = 2, .m...
  # Changed from baseline: cols = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(roll_values(data = df, cols = 1, add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cols': Must be of type 'character', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = NULL, add = 2,...
  # Changed from baseline: cols = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(roll_values(data = df, cols = NULL, add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is a data.frame, 'cols' must be specified."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: add = -2
  xpectr::set_test_seed(42)
  # Assigning output
  output_19782 <- roll_values(data = df, cols = c("w", "d"), add = -2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19782),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19782[["w"]],
    c(5, 6, 1, 2, 3, 4, 5),
    tolerance = 1e-4)
  expect_equal(
    output_19782[["d"]],
    c(358, 43, 88, 133, 178, 268, 358),
    tolerance = 1e-4)
  expect_equal(
    output_19782[[".range_str"]],
    c("w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)",
      "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)",
      "w=[1,7),d=[0,360)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19782),
    c("w", "d", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19782),
    c("numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19782),
    c("double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19782),
    c(7L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19782)),
    character(0),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: add = c(-2, 2)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11174 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = c(-2, 2), .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'add': Must have length 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: add = 0
  xpectr::set_test_seed(42)
  # Assigning output
  output_14749 <- roll_values(data = df, cols = c("w", "d"), add = 0, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14749),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14749[["w"]],
    c(1, 2, 3, 4, 5, 6, 1),
    tolerance = 1e-4)
  expect_equal(
    output_14749[["d"]],
    c(0, 45, 90, 135, 180, 270, 0),
    tolerance = 1e-4)
  expect_equal(
    output_14749[[".range_str"]],
    c("w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)",
      "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)",
      "w=[1,7),d=[0,360)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_14749),
    c("w", "d", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14749),
    c("numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14749),
    c("double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14749),
    c(7L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14749)),
    character(0),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: add = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15603 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = "hej", .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'add': Must be of type 'number', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: add = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19040 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = NA, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'add': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: add = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11387 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = NULL, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'add': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: .min = 20
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19888 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = 20, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error']]),
    xpectr::strip("'.min' was greater than '.max'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: .min = -10
  xpectr::set_test_seed(42)
  # Assigning output
  output_19466 <- roll_values(data = df, cols = c("w", "d"), add = 2, .min = -10, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19466),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19466[["w"]],
    c(3, 4, 5, 6, -10, -9, -8),
    tolerance = 1e-4)
  expect_equal(
    output_19466[["d"]],
    c(2, 47, 92, 137, 182, 272, -8),
    tolerance = 1e-4)
  expect_equal(
    output_19466[[".range_str"]],
    c("w=[-10,7),d=[-10,360)", "w=[-10,7),d=[-10,360)", "w=[-10,7),d=[-10,360)",
      "w=[-10,7),d=[-10,360)", "w=[-10,7),d=[-10,360)", "w=[-10,7),d=[-10,360)",
      "w=[-10,7),d=[-10,360)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19466),
    c("w", "d", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19466),
    c("numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19466),
    c("double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19466),
    c(7L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19466)),
    character(0),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: .min = "h"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10824 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = "h", .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.min': Must be of type 'number' (or 'NULL'), not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: .min = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15142 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NA, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.min': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: .max = 30
  xpectr::set_test_seed(42)
  # Assigning output
  output_13902 <- roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = 30, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_13902),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13902[["w"]],
    c(3, 4, 5, 6, 7, 8, 9),
    tolerance = 1e-4)
  expect_equal(
    output_13902[["d"]],
    c(2, 17, 2, 17, 2, 2, 2),
    tolerance = 1e-4)
  expect_equal(
    output_13902[[".range_str"]],
    c("w=[1,30),d=[0,30)", "w=[1,30),d=[0,30)", "w=[1,30),d=[0,30)",
      "w=[1,30),d=[0,30)", "w=[1,30),d=[0,30)", "w=[1,30),d=[0,30)",
      "w=[1,30),d=[0,30)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_13902),
    c("w", "d", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13902),
    c("numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13902),
    c("double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13902),
    c(7L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13902)),
    character(0),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: .max = -10
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19057 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = -10, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error']]),
    xpectr::strip("'.min' was greater than '.max'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: .max = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14469 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NA, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable '.max': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: between = 1
  xpectr::set_test_seed(42)
  # Assigning output
  output_18360 <- roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 1, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_18360),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_18360[["w"]],
    c(3, 4, 5, 6, 7, 1, 2),
    tolerance = 1e-4)
  expect_equal(
    output_18360[["d"]],
    c(2, 47, 92, 137, 182, 272, 1),
    tolerance = 1e-4)
  expect_equal(
    output_18360[[".range_str"]],
    c("w=[1,7],d=[0,360]", "w=[1,7],d=[0,360]", "w=[1,7],d=[0,360]",
      "w=[1,7],d=[0,360]", "w=[1,7],d=[0,360]", "w=[1,7],d=[0,360]",
      "w=[1,7],d=[0,360]"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_18360),
    c("w", "d", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_18360),
    c("numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_18360),
    c("double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_18360),
    c(7L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_18360)),
    character(0),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: between = -1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17375 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = -1, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'between': Element 1 is not >= 0."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: between = "h"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18110 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = "h", na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'between': Must be of type 'number', not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: between = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13881 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = NA, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13881[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'between': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13881[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: between = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16851 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = NULL, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'between': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: na.rm = TRUE
  xpectr::set_test_seed(42)
  # Assigning output
  output_10039 <- roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = TRUE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_10039),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_10039[["w"]],
    c(3, 4, 5, 6, 1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    output_10039[["d"]],
    c(2, 47, 92, 137, 182, 272, 2),
    tolerance = 1e-4)
  expect_equal(
    output_10039[[".range_str"]],
    c("w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)",
      "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)",
      "w=[1,7),d=[0,360)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_10039),
    c("w", "d", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_10039),
    c("numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_10039),
    c("double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_10039),
    c(7L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_10039)),
    character(0),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: na.rm = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18329 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = NA, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18329[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'na.rm': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18329[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: na.rm = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10073 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = NULL, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10073[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'na.rm': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10073[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: suffix = "_rolled"
  xpectr::set_test_seed(42)
  # Assigning output
  output_12076 <- roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "_rolled", keep_original = FALSE, range_col_name = ".range", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_12076),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_12076[["w_rolled"]],
    c(3, 4, 5, 6, 1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    output_12076[["d_rolled"]],
    c(2, 47, 92, 137, 182, 272, 2),
    tolerance = 1e-4)
  expect_equal(
    output_12076[[".range_str"]],
    c("w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)",
      "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)",
      "w=[1,7),d=[0,360)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_12076),
    c("w_rolled", "d_rolled", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_12076),
    c("numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_12076),
    c("double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_12076),
    c(7L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_12076)),
    character(0),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: suffix = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19066 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = 1, keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19066[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': Must be of type 'string', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19066[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: suffix = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16117 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = NA, keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16117[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16117[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: suffix = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13795 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = NULL, keep_original = FALSE, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13795[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13795[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: keep_original = TRUE
  xpectr::set_test_seed(42)
  # Assigning output
  output_14357 <- roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = TRUE, range_col_name = ".range", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14357),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14357[["ch"]],
    c("A", "B", "C", "D", "E", "F", "G"),
    fixed = TRUE)
  expect_equal(
    output_14357[["g"]],
    c(1, 1, 2, 2, 3, 3, 3),
    tolerance = 1e-4)
  expect_equal(
    output_14357[["w"]],
    c(3, 4, 5, 6, 1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    output_14357[["d"]],
    c(2, 47, 92, 137, 182, 272, 2),
    tolerance = 1e-4)
  expect_equal(
    output_14357[[".range_str"]],
    c("w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)",
      "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)",
      "w=[1,7),d=[0,360)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_14357),
    c("ch", "g", "w", "d", ".range", ".range_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14357),
    c("character", "numeric", "numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14357),
    c("character", "double", "double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14357),
    7:6)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14357)),
    character(0),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: keep_original = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10374 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = 1, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10374[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10374[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: keep_original = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19735 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = NA, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19735[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19735[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: keep_original = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14317 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = NULL, range_col_name = ".range", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14317[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14317[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: range_col_name = ".r"
  xpectr::set_test_seed(42)
  # Assigning output
  output_19575 <- roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".r", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19575),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19575[["w"]],
    c(3, 4, 5, 6, 1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    output_19575[["d"]],
    c(2, 47, 92, 137, 182, 272, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19575[[".r_str"]],
    c("w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)",
      "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)", "w=[1,7),d=[0,360)",
      "w=[1,7),d=[0,360)"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19575),
    c("w", "d", ".r", ".r_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19575),
    c("numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19575),
    c("double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19575),
    c(7L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19575)),
    character(0),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: range_col_name = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18877 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = 1, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18877[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'range_col_name': Must be of type 'string' (or 'NULL'), not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18877[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: range_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16399 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = NA, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16399[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'range_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16399[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: range_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_19709 <- roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19709),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19709[["w"]],
    c(3, 4, 5, 6, 1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    output_19709[["d"]],
    c(2, 47, 92, 137, 182, 272, 2),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19709),
    c("w", "d"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19709),
    c("numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19709),
    c("double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19709),
    c(7L, 2L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19709)),
    character(0),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: range_col_name, overw...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16188 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = "g", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16188[['error']]),
    xpectr::strip("1 assertions failed:\n * The column 'g' already exists and 'overwrite' is disabled."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16188[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: overwrite = FALSE
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13334 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13334[['error']]),
    xpectr::strip("Adding these dimensions would overwrite existing columns: w, d."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13334[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing roll_values(data = df, cols = c("w", "d"), a...
  # Changed from baseline: overwrite = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13467 <- xpectr::capture_side_effects(roll_values(data = df, cols = c("w", "d"), add = 2, .min = NULL, .max = NULL, between = 0, na.rm = FALSE, suffix = "", keep_original = FALSE, range_col_name = ".range", overwrite = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13467[['error']]),
    xpectr::strip("Assertion on 'overwrite' failed: Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13467[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'roll_values'                                           ####
  #
})

test_that("testing wrap_to_range()", {
  xpectr::set_test_seed(42)

  df <- data.frame(
    "w" = 1:7,
    "d" = c(0, 45, 90, 135, 180, 270, NA),
    "ch" = LETTERS[1:7],
    "g" = c(1,1,2,2,3,3,3),
    stringsAsFactors = FALSE
  )

  # Simply checks that changing the arguments is picked up by roll_values

  ## Testing 'wrap_to_range(df, cols = c("w", "d"), .min =...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- wrap_to_range(df, cols = c("w", "d"), .min = 2, .max = 6, between = 1, na.rm = TRUE,suffix = "_wrt", keep_original = TRUE, range_col_name = ".hey")
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["w"]],
    c(1, 2, 3, 4, 5, 6, 7),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["d"]],
    c(0, 45, 90, 135, 180, 270, NA),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["ch"]],
    c("A", "B", "C", "D", "E", "F", "G"))
  expect_equal(
    output_19148[["g"]],
    c(1, 1, 2, 2, 3, 3, 3),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["w_wrt"]],
    c(6, 2, 3, 4, 5, 6, 2),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["d_wrt"]],
    c(5, 5, 5, 5, 5, 5, NA),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".hey_str"]],
    c("w=[2,6],d=[2,6]", "w=[2,6],d=[2,6]", "w=[2,6],d=[2,6]", "w=[2,6],d=[2,6]",
      "w=[2,6],d=[2,6]", "w=[2,6],d=[2,6]", "w=[2,6],d=[2,6]"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("w", "d", "ch", "g", "w_wrt", "d_wrt", ".hey", ".hey_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("integer", "numeric", "character", "numeric", "numeric", "numeric",
      "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("integer", "double", "character", "double", "double", "double",
      "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    7:8)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'wrap_to_range(df, cols = c("w", "d"), .min =...'     ####



  ## Testing 'wrap_to_range_vec(df$d, .min = 2, .max = 6, ...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- wrap_to_range_vec(df$d, .min = 2, .max = 6, between = 1, na.rm = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(5, 5, 5, 5, 5, 5, NA),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    7L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    7L)
  ## Finished testing 'wrap_to_range_vec(df$d, .min = 2, .max = 6, ...'     ####


})
