% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rearrangers.R
\name{rearranger_}
\alias{rearranger_}
\title{Wrapper for running rearranging methods}
\usage{
rearranger_(
  data,
  rearrange_fn,
  check_fn,
  cols = NULL,
  allowed_types = c("numeric", "factor", "character"),
  col = deprecated(),
  overwrite = FALSE,
  origin_fn = NULL,
  ...
)
}
\arguments{
\item{data}{\code{data.frame} or \code{vector}.}

\item{rearrange_fn}{Rearrange function to apply.}

\item{check_fn}{Function with checks post-preparation of \code{`data`} and \code{`col(s)`}.
Should not return anything.}

\item{cols}{Column(s) to create sorting factor by.
When \code{`NULL`} and \code{`data`} is a \code{data.frame},
the row numbers are used.}

\item{allowed_types}{Allowed types of the \code{`col(s)`} columns. The type restrictions do not apply to
columns not mentioned in the \code{`col(s)`} argument.}

\item{col}{Column to create sorting factor by.
When \code{`NULL`} and \code{`data`} is a \code{data.frame},
the row numbers are used.}

\item{overwrite}{Whether to allow overwriting of existing columns. (Logical)}

\item{origin_fn}{Function for finding the origin coordinates.

\strong{Input}: Each column will be passed as a \code{vector} in the order of \code{`cols`}.

\strong{Output}: A \code{vector} with one scalar per dimension.

Can be created with \code{\link[rearrr:create_origin_fn]{create_origin_fn()}} if you want to apply
the same function to each dimension.

E.g. \code{`create_origin_fn(median)`} would find the median of each column.

\strong{Built-in functions} are \code{\link[rearrr:centroid]{centroid()}},
\code{\link[rearrr:most_centered]{most_centered()}},
and \code{\link[rearrr:midrange]{midrange()}}}

\item{...}{Named arguments for the \code{`rearrange_fn`}.}
}
\value{
The sorted \code{data.frame} (\code{tibble}) / \code{vector}.
Optionally with (a) sorting factor(s) added.

When \code{`data`} is a \code{vector} and
no extra factors are returned by \code{`rearrange_fn`},
the output will be a \code{vector}. Otherwise, a \code{data.frame}.
}
\description{
Wrapper for running rearranging methods
}
\keyword{internal}
