% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratified.R
\name{Nstrat}
\alias{Nstrat}
\title{Stratified Abundance Estimator}
\usage{
Nstrat(n1, n2, m2, estimator = "Chapman")
}
\arguments{
\item{n1}{Vector of individuals captured and marked in the first sample, from
each stratum}

\item{n2}{Vector of individuals captured and marked in the second sample,
from each stratum}

\item{m2}{Vector of marked individuals recaptured in the second sample, from
each stratum}

\item{estimator}{The type of estimator to use.  Allowed values are
\code{"Chapman"}, \code{"Petersen"}, and \code{"Bailey"}.  Default to
\code{"Chapman"}.}
}
\value{
The value of the stratified estimator
}
\description{
Calculates the value of the stratified estimator for abundance
  in a mark-recapture experiment, from vectors of sample sizes and number of
  recaptures, with each element corresponding to each sampling stratum.
}
\note{
It is possible that even the stratified estimate may be biased if
  capture probabilities differ greatly between strata.  However, the bias in
  the stratified estimator will be much less than an estimator calculated
  without stratification.
}
\examples{
Nstrat(n1=c(100,200), n2=c(100,500), m2=c(10,10))
}
\seealso{
\link{strattest}, \link{rstrat}, \link{vstrat},  \link{sestrat}, \link{cistrat},
  \link{NChapman}, \link{NPetersen}, \link{NBailey}
}
\author{
Matt Tyers
}
