% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdraws_rpvals.R
\name{powChapman}
\alias{powChapman}
\title{Power for Hypothesis Testing Using the Chapman Estimator}
\usage{
powChapman(
  nullN,
  trueN,
  n1,
  n2,
  alpha = 0.05,
  nsim = 10000,
  alternative = "less"
)
}
\arguments{
\item{nullN}{The abundance given by the null hypothesis}

\item{trueN}{The assumed abundance for the power calculation}

\item{n1}{Number of individuals captured and marked in the first sample}

\item{n2}{Number of individuals captured in the second sample}

\item{alpha}{The alpha level for the test}

\item{nsim}{Number of simulated values to draw.  Defaults to 10000.}

\item{alternative}{Direction of the alternative hypothesis.  Allowed values
are \code{"less"}, \code{"greater"}, or \code{"2-sided"}.  Defaults to \code{"less"}.}
}
\value{
The approximate power of the specified hypothesis test, for the specified alternative value.
}
\description{
Approximates the power of a hypothesis test of the Chapman
  estimator by means of many simulated draws from a specified alternative distribution, conditioned on sample sizes.
}
\note{
Any Petersen-type estimator (such as this) depends on a set of
  assumptions: \itemize{ \item  The population is closed; that is, that there
  are no births, deaths, immigration, or emigration between sampling events
  \item All individuals have the same probability of capture in one of the
  two events, or complete mixing occurs between events \item Marking in the
  first event does not affect probability of recapture in the second event
  \item Individuals do not lose marks between events \item All marks will be
  reported in the second event }
}
\examples{
powChapman(nullN=500, trueN=400, n1=100, n2=100, nsim=1000)

Ntotry <- seq(from=250, to=450, by=25)
pows <- sapply(Ntotry, function(x)
  powChapman(nullN=500, trueN=x, n1=100, n2=100, nsim=1000))
plot(Ntotry, pows)
}
\seealso{
\link{NChapman}, \link{vChapman}, \link{seChapman}, \link{rChapman},
  \link{pChapman}, \link{ciChapman}
}
\author{
Matt Tyers
}
