% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log.R
\name{step_log}
\alias{step_log}
\alias{tidy.step_log}
\title{Logarithmic Transformation}
\usage{
step_log(recipe, ..., role = NA, trained = FALSE, base = exp(1),
  columns = NULL)

\method{tidy}{step_log}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[=selections]{selections()}}
for more details.  For the \code{tidy} method, these are not
currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{base}{A numeric value for the base.}

\item{columns}{A character string of variable names that will
be (eventually) populated by the \code{terms} argument.}

\item{x}{A \code{step_log} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
columns that will be affected) and \code{base}.
}
\description{
\code{step_log} creates a \emph{specification} of a recipe step
that will log transform data.
}
\examples{
set.seed(313)
examples <- matrix(exp(rnorm(40)), ncol = 2)
examples <- as.data.frame(examples)

rec <- recipe(~ V1 + V2, data = examples)

log_trans <- rec  \%>\%
  step_log(all_predictors())

log_obj <- prep(log_trans, training = examples)

transformed_te <- bake(log_obj, examples)
plot(examples$V1, transformed_te$V1)

tidy(log_trans, number = 1)
tidy(log_obj, number = 1)
}
\seealso{
\code{\link[=step_logit]{step_logit()}} \code{\link[=step_invlogit]{step_invlogit()}}
\code{\link[=step_hyperbolic]{step_hyperbolic()}}  \code{\link[=step_sqrt]{step_sqrt()}}
\code{\link[=recipe]{recipe()}} \code{\link[=prep.recipe]{prep.recipe()}}
\code{\link[=bake.recipe]{bake.recipe()}}
}
\concept{
preprocessing transformation_methods
}
\keyword{datagen}
