% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummy.R
\name{step_dummy}
\alias{step_dummy}
\title{Create traditional dummy variables}
\usage{
step_dummy(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  one_hot = FALSE,
  preserve = deprecated(),
  naming = dummy_names,
  levels = NULL,
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("dummy")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details. The selected
variables \emph{must} be factors.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{one_hot}{A logical. For C levels, should C dummy variables be created
rather than C-1?}

\item{preserve}{Use \code{keep_original_cols} to specify whether the selected
column(s) should be retained (in addition to the new dummy variables).}

\item{naming}{A function that defines the naming convention for
new dummy columns. See Details below.}

\item{levels}{A list that contains the information needed to
create dummy variables for each variable contained in
\code{terms}. This is \code{NULL} until the step is trained by
\code{\link[=prep]{prep()}}.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_dummy()} creates a \emph{specification} of a recipe
step that will convert nominal data (e.g. character or factors)
into one or more numeric binary model terms for the levels of
the original data.
}
\details{
\code{step_dummy()} will create a set of binary dummy
variables from a factor variable. For example, if an unordered
factor column in the data set has levels of "red", "green",
"blue", the dummy variable bake will create two additional
columns of 0/1 data for two of those three values (and remove
the original column). For ordered factors, polynomial contrasts
are used to encode the numeric values.

By default, the excluded dummy variable (i.e. the reference
cell) will correspond to the first level of the unordered
factor being converted.

This recipe step allows for flexible naming of the resulting
variables. For an unordered factor named \code{x}, with levels \code{"a"}
and \code{"b"}, the default naming convention would be to create a
new variable called \code{x_b}. The naming format can be changed using
the \code{naming} argument; the function \code{\link[=dummy_names]{dummy_names()}} is the
default.

To change the type of contrast being used, change the global
contrast option via \code{options}.

When the factor being converted has a missing value, all of the
corresponding dummy variables are also missing. See \code{\link[=step_unknown]{step_unknown()}} for
a solution.

When data to be processed contains novel levels (i.e., not
contained in the training set), a missing value is assigned to
the results. See \code{\link[=step_other]{step_other()}} for an alternative.

If no columns are selected (perhaps due to an earlier \code{step_zv()}),
\code{\link[=bake]{bake()}} will return the data as-is (e.g. with no dummy variables).

Note that, by default, the new dummy variable column names obey the naming
rules for columns. If there are levels such as "0", \code{\link[=dummy_names]{dummy_names()}} will put
a leading "X" in front of the level (since it uses \code{\link[=make.names]{make.names()}}). This can
be changed by passing in a different function to the \code{naming} argument for
this step.

The \href{https://recipes.tidymodels.org/articles/Dummies.html}{package vignette for dummy variables}
and interactions has more information.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns
\code{terms} (the selectors or original variables selected) and \code{columns}
(the list of corresponding binary columns) is returned.
}

\examples{
library(modeldata)
data(okc)
okc <- okc[complete.cases(okc),]

# Original data: diet has 18 levels
length(unique(okc$diet))
unique(okc$diet) \%>\% sort()

rec <- recipe(~ diet + age + height, data = okc)

# Default dummy coding: 17 dummy variables
dummies <- rec \%>\%
    step_dummy(diet) \%>\%
    prep(training = okc)

dummy_data <- bake(dummies, new_data = NULL)

dummy_data \%>\%
    select(starts_with("diet")) \%>\%
    names() # level "anything" is the reference level

# Obtain the full set of 18 dummy variables using `one_hot` option
dummies_one_hot <- rec \%>\%
    step_dummy(diet, one_hot = TRUE) \%>\%
    prep(training = okc)

dummy_data_one_hot <- bake(dummies_one_hot, new_data = NULL)

dummy_data_one_hot \%>\%
    select(starts_with("diet")) \%>\%
    names() # no reference level


tidy(dummies, number = 1)
tidy(dummies_one_hot, number = 1)
}
\seealso{
\code{\link[=dummy_names]{dummy_names()}}

Other dummy variable and encoding steps: 
\code{\link{step_bin2factor}()},
\code{\link{step_count}()},
\code{\link{step_date}()},
\code{\link{step_dummy_extract}()},
\code{\link{step_dummy_multi_choice}()},
\code{\link{step_factor2string}()},
\code{\link{step_holiday}()},
\code{\link{step_indicate_na}()},
\code{\link{step_integer}()},
\code{\link{step_novel}()},
\code{\link{step_num2factor}()},
\code{\link{step_ordinalscore}()},
\code{\link{step_other}()},
\code{\link{step_regex}()},
\code{\link{step_relevel}()},
\code{\link{step_string2factor}()},
\code{\link{step_unknown}()},
\code{\link{step_unorder}()}
}
\concept{dummy variable and encoding steps}
