% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_blocking.R
\name{pair_blocking}
\alias{pair_blocking}
\title{Generate pairs using simple blocking}
\usage{
pair_blocking(x, y, blocking_var = NULL, large = TRUE, add_xy = TRUE,
  chunk_size = 1e+07)
}
\arguments{
\item{x}{first \code{data.frame}}

\item{y}{second \code{data.frame}}

\item{blocking_var}{the variables defining the blocks or strata for which 
all pairs of \code{x} and \code{y} will be generated.}

\item{large}{should the pairs be returned as a \code{\link{ldat}} object.}

\item{add_xy}{add \code{x} and \code{y} as attributes to the returned 
pairs. This makes calling some subsequent operations that need \code{x} and 
\code{y} (such as \code{\link{compare_pairs}} easier.}

\item{chunk_size}{used when \code{large = TRUE} to specify the approximate 
number of pairs that are kept in memory.}
}
\value{
When \code{large} is \code{FALSE}, a \code{data.frame} with two columns, 
\code{x} and \code{y}, is returned. Columns \code{x} and \code{y} are 
row numbers from \code{data.frame}s \code{x} and \code{y} respectively. 
When \code{large} is \code{TRUE}, an object of type \code{ldat} is returned.
}
\description{
Generates all combinations of records from \code{x} and \code{y} where the 
blocking variables are equal.
}
\details{
Generating (all) pairs of the records of two data sets, is usually the first 
step when linking the two data sets. However, this often results in a too 
large number of records. Therefore, blocking is usually applied.
}
\examples{
data("linkexample1", "linkexample2")
pairs <- pair_blocking(linkexample1, linkexample2, "postcode")

\dontshow{gc()}

}
