% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_image.R
\name{add_image}
\alias{add_image}
\title{Add a raster image to a plot}
\usage{
add_image(obj, x = NULL, y = NULL, width = NULL, interpolate = TRUE, angle = 0)
}
\arguments{
\item{obj}{An array of the dimensions height x width x channels,
such as read in by \link[png:readPNG]{png::readPNG} or \link{readImage}, or the \code{original_img}
and \code{recolored_img} elements of a \code{recolorize} object.}

\item{x, y}{The x and y coordinates on which the image should be centered.}

\item{width}{Image width, in x-axis units.}

\item{interpolate}{Passed to \link[graphics:rasterImage]{graphics::rasterImage}. Use linear
interpolation when scaling the image?}

\item{angle}{Passed to \link[graphics:rasterImage]{graphics::rasterImage}. The angle (in degrees)
for rotating the image.}
}
\value{
Nothing; adds an image to the existing plot window.
}
\description{
Adds a raster image (a 3D array) to an existing plot as an image.
A silly, generic function, but nice for visualization. Sort of like
\link[graphics:points]{graphics::points}, but for images.
}
\examples{
images <- dir(system.file("extdata", package = "recolorize"),
              ".png", full.names = TRUE)
x <- runif(5)
y <- runif(5)
plot(x, y,
     xlim = range(x) + c(-0.2, 0.2),
     ylim = range(y) + c(-0.2, 0.2))
for (i in 1:length(images)) {
  img <- readImage(images[i])
  add_image(img, x[i], y[i], width = 0.1)
}

}
