% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExecMetadata.R
\docType{methods}
\name{readExecMeta}
\alias{readExecMeta}
\alias{readExecMeta,Recordr-method}
\title{Retrieve saved execution metadata.}
\usage{
readExecMeta(recordr, ...)

\S4method{readExecMeta}{Recordr}(recordr, executionId = as.character(NA),
  script = as.character(NA), startTime = as.character(NA),
  endTime = as.character(NA), tag = as.character(NA),
  errorMessage = as.character(NA), seq = as.integer(NA),
  orderBy = as.character(NA), sortOrder = "ascending", delete = FALSE,
  ...)
}
\arguments{
\item{recordr}{A Recordr object}

\item{...}{additional parameters}

\item{executionId}{A character value that specifies an execution identifier to search for.}

\item{script}{A character value that specifies a script name to search for.}

\item{startTime}{A character value that specifies the start of a time range. This value must be
entered in the form 'YYYY-MM-DD HH:MM:SS' but can be shortened to "YYYY-MM-DD"}

\item{endTime}{A character value that specifies the end of a time to to search. This value must
be entered in the form 'YYYY-MM-DD HH:MM:SS' but can be shortened to "YYYY-MM-DD"}

\item{tag}{A tag value to search for}

\item{errorMessage}{An execution error message to search for.}

\item{seq}{An exectioin sequence nuber}

\item{orderBy}{The column to sort the result set by.}

\item{sortOrder}{The sort order. Values include "ascending", "descending".}

\item{delete}{a \code{"logical"}, if TRUE, the selected runs are deleted (default: FALSE).}
}
\value{
A list of ExecMetadata objects
}
\description{
Execution metadata is retrived from recordr database table _execmeta_ 
based on search parameters.
}
\details{
The \code{"startTime"} and \code{"endTime"} parameters are used to specify a time
range to find runs that started execution between the start and end times that are specified.
}
\seealso{
\code{\link[=ExecMetadata-class]{ExecMetadata}} { class description}
}

