% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\docType{methods}
\name{summary,rateReg-method}
\alias{summary,rateReg-method}
\title{Summarizing a Fitted Model}
\usage{
\S4method{summary}{rateReg}(object, showCall = TRUE, showKnots = TRUE, ...)
}
\arguments{
\item{object}{\code{\link{rateReg-class}} object.}

\item{showCall}{A logic value with dafault \code{TRUE},
indicating whether function \code{show} 
prints out the original call information of \code{rateReg}.
It may be helpful for a more concise printout.}

\item{showKnots}{A logic value with default \code{TRUE}, 
indicating whether function \code{show}
prints out the internal and boundary knots.
Similar to argument \code{showCall}, It may be helpful
for a more concise printout.}

\item{...}{Other arguments for future usage.}
}
\value{
summaryRateReg-class object
}
\description{
Summary of estimated coefficients of covariates, rate function bases,
and estimated rate parameter of frailty random variable, etc.,
which can be printed out by \code{show}.
}
\details{
\code{summary,rateReg-method} returns a
\code{\link{summaryRateReg-class}} object,
whose slots include
\itemize{
    \item \code{covarCoef}: Estimated covariate coefficients.
    \item \code{frailtyPar}: Estimated rate parameter of gamma frailty.
    \item \code{baseRateCoef}: Estimated coeffcients of baseline
        rate function.
}
For the meaning of other slots, see \code{\link{rateReg}}.
}
\examples{
## See examples given in function rateReg.
}
\seealso{
\code{\link{rateReg}} for model fitting;
\code{\link{coef,rateReg-method}} for point estimates of
covariate coefficients; 
\code{\link{confint,rateReg-method}} for confidence intervals
of covariate coeffcients;
\code{\link{baseRate,rateReg-method}} for coefficients of baseline
rate function.
}

