% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportUsers.R
\name{exportUsers}
\alias{exportUsers}
\alias{exportUsers.redcapDbConnection}
\alias{exportUsers.redcapApiConnection}
\title{Export the Users for a Project}
\usage{
exportUsers(rcon, ...)

\method{exportUsers}{redcapDbConnection}(rcon, dates = TRUE, labels = TRUE,
  ...)

\method{exportUsers}{redcapApiConnection}(rcon, dates = TRUE, labels = TRUE,
  ..., bundle = getOption("redcap_bundle"),
  error_handling = getOption("redcap_error_handling"))
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}.}

\item{...}{Arguments to be passed to other methods.}

\item{dates}{Logical. Indicates if the expiration date is converted to a
\code{POSIXct} object.}

\item{labels}{Logical. Indicates if the data export and form access rights are
converted to factor objects.}

\item{bundle}{A \code{redcap_bundle} object.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}
}
\value{
Returns a data frame. The number of columns in the data frame will depend on your 
version of REDCap.
\itemize{
  \item{\code{username }}{User name}
  \item{\code{email }}{The user's e-mail address}
  \item{\code{firstname }}{The user's first name}
  \item{\code{lastname }}{The user's last name}
  \item{\code{expiration }}{The expiration date of the user's access to the project}
  \item{\code{data_access_group }}{The data access group the user is assigned to}
  \item{\code{data_export }}{The user's data export rights. 0=no access, 
    2=De-Identified, 1=Full Data Set}
  \item{\code{mobile_app }}{(6.5.0+) Flag for if the user has permissions for the 
    mobile application}
  \item{\code{mobile_app_download_data }}{(6.5.0+) Flag for if the user may download
    data from the mobile app}
}

The data frame will have one additional column for each form giving the user's 
form-level permissions in the project.  0=no access, 2=read only, 
1=view records/responses and
edit records (survey responses are read-only), 3 = edit survey responses
}
\description{
Retrieve a data frame giving the users, expiration dates,
and data access privileges for each user.
}
\details{
For some reason I have yet to identify, some User Tables do not
export correctly. In some situations, the fields are all shifted one
column to the left and the form names are not always exported.
This seems to be more common in projects still in Development mode.
I have seen one instance of a project in Production where one user had
one more column given than any other user.  If you notice this behavior,
please report it to me as it may help me narrow down the source of the problem
}
\section{REDCap API Documentation (6.5.0)}{

This function allows you to export the users for a project
}

\section{REDCap Version}{

5.8.2 (Perhaps earlier)
}

\section{Known REDCap Limitations}{

None
}

\references{
Please refer to your institution's API documentation.

Additional details on API parameters are found on the package wiki at
\url{https://github.com/nutterb/redcapAPI/wiki/REDCap-API-Parameters}
}
\author{
Benjamin Nutter
}
