% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportFiles.R
\name{exportFiles}
\alias{exportFiles}
\alias{exportFiles.redcapDbConnection}
\alias{exportFiles.redcapApiConnection}
\title{Exports a File attached to a Record}
\usage{
exportFiles(
  rcon,
  record,
  field,
  event,
  dir,
  filePrefix = TRUE,
  ...,
  bundle = getOption("redcap_bundle")
)

\method{exportFiles}{redcapDbConnection}(
  rcon,
  record,
  field,
  event,
  dir,
  filePrefix = TRUE,
  ...,
  bundle = getOption("redcap_bundle")
)

\method{exportFiles}{redcapApiConnection}(
  rcon,
  record,
  field,
  event = NULL,
  dir,
  filePrefix = TRUE,
  ...,
  bundle = getOption("redcap_bundle"),
  error_handling = getOption("redcap_error_handling")
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}}

\item{record}{The record ID in which the desired file is stored. Must be length 1.}

\item{field}{The field name in which the file is stored. Must be length 1.}

\item{event}{The event name for the file.  Must be length 1.
This applies only to longitudinal projects.  If the event is not
supplied for a longitudinal project, the API will return an error message}

\item{dir}{A directory/folder to which the file will be saved. 
By default, the working directory is used}

\item{filePrefix}{Logical.  Determines if a prefix is appended to the file 
name.  The prefix takes the form [record_id]-[event_name]-[file_name].  
The file name is always the same name of the file as it exists in REDCap}

\item{...}{Arguments to be passed to other methods}

\item{bundle}{A \code{redcapBundle} object as created by \code{exportBundle}.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}
}
\description{
A single file from a single record is retrieved.  The behavior 
of this function is consistent with the behavior of the API, which only 
allows one file to be downloaded at a time
}
\details{
The function may only export a single file.  
See the examples for suggestions on exporting multiple files.

Note that the name of the file can not be changed.  Whatever name exists in 
REDCap is the name that will be used, although the record ID and event name 
may be appended as a prefix
}
\section{REDCap API Documentation (6.5.0)}{

This method allows you to download a document that has been attached to an 
individual record for a File Upload field. Please note that this method may also 
be used for Signature fields (i.e. File Upload fields with "signature" validation type).

Note about export rights: Please be aware that Data Export user rights will be 
applied to this API request. For example, if you have "No Access" data export rights 
in the project, then the API file export will fail and return an error. And if you 
have "De-Identified" or "Remove all tagged Identifier fields" data export rights, 
then the API file export will fail and return an error *only if* the File Upload 
field has been tagged as an Identifier field. To make sure that your API request 
does not return an error, you should have "Full Data Set" export rights in the project.
}

\section{REDCap Version}{

5.8.2+
}

\section{Known REDCap Limitations}{

None
}

\references{
Please refer to your institution's API documentation.

Additional details on API parameters are found on the package wiki at
\url{https://github.com/nutterb/redcapAPI/wiki/REDCap-API-Parameters}
}
\author{
Benjamin Nutter
}
