% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importEvents.R
\name{importEvents}
\alias{importEvents}
\title{Import Events to REDCap}
\usage{
importEvents(
  rcon,
  event_data,
  override = FALSE,
  refresh = TRUE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)

importEvents(
  rcon,
  event_data,
  override = FALSE,
  refresh = TRUE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{a \code{redcapConnection} object.}

\item{event_data}{\code{data.frame}. Must have columns "event_name"
and "arm_num". To modify existing events, it must also have a column
"unique_event_name". It may optionally have columns for 
"day_offset", "offset_min", "offset_max".}

\item{override}{\code{logical(1)}. Defaults to \code{FALSE}, which will
only add new events or modify existing events. When \code{TRUE}, all
existing events are deleted and replaced with the events in 
\code{event_data}.}

\item{refresh}{\code{logical(1)}. When \code{TRUE}, cached event data will 
be refreshed after the import.}

\item{...}{Additional arguments to pass to other methods.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}}
}
\description{
This method allows you to import Events into a project or to 
  update existing Events' attributes, such as the event name, days offset, 
  etc. The unique event name of an Event cannot be changed because it is 
  auto-generated by REDCap. Please note that the only way to update an 
  existing Event is to provide the unique_event_name attribute, 
  and if the unique_event_name attribute is missing for an Event being 
  imported (when override=0), it will assume it to be a new Event that
  should be created. Notice: Because of the 'override' parameter's 
  destructive nature, this method may only use override=1 for projects 
  in Development status.
}
