% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{match_numbers}
\alias{match_numbers}
\title{Renumber districts to match an existing plan}
\usage{
match_numbers(data, plan, col = "pop_overlap", force = FALSE)
}
\arguments{
\item{data}{a \code{redist_plans} object}

\item{plan}{a character vector giving the name of the plan to match to (e.g.,
for a reference plan), or an integer vector containing the plan itself.}

\item{col}{the name of a new column to store the vector of population overlap
with the reference plan: the fraction of the total population who are in
the same district under each plan and the reference plan. Set to
\code{NULL} if no column should be created.}

\item{force}{if \code{TRUE}, force computation when there are more than 1,000
renumbering options in any plan.}
}
\value{
a modified \code{redist_plans} object. New district numbers will be
stored as an ordered factor variable in the \code{district} column. The
district numbers in the plan matrix will match the levels of this factor.
}
\description{
District numbers in simulated plans are by and large random.  This
function attempts to renumber the districts across all simulated plans to
match the numbers in a provided plan.
}
\concept{analyze}
