% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compactness.R
\name{comp_polsby}
\alias{comp_polsby}
\title{Calculate Polsby Popper Compactness}
\usage{
comp_polsby(
  plans,
  shp,
  use_Rcpp,
  perim_path,
  perim_df,
  epsg = 3857,
  ncores = 1
)
}
\arguments{
\item{plans}{redist_plans object or plans_matrix where each row indicates a district assignment and each column is a plan}

\item{shp}{redist_map object or tibble with sf geometry column}

\item{use_Rcpp}{Logical. Use Rcpp?}

\item{perim_path}{path to perimeter tibble saved by \code{prep_perims()}}

\item{perim_df}{tibble of perimeters from \code{prep_perims()}}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}

\item{ncores}{numeric. Number of cores to use. Default is 1.}
}
\value{
numeric vector
}
\description{
Calculate Polsby Popper Compactness
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
comp_polsby(plans = nh$r_2020, shp = nh)

# Or many plans:
comp_polsby(plans = nh_m[, 3:5], shp = nh)

}
\references{
Cox, E. 1927. A Method of Assigning Numerical and Percentage Values to the
Degree of Roundness of Sand Grains. Journal of Paleontology, 1(3), 179-183.

Polsby, Daniel D., and Robert D. Popper. 1991. “The Third Criterion:
Compactness as a procedural safeguard against partisan gerrymandering.”
Yale Law & Policy Review 9 (2): 301–353.
}
\concept{compactness}
