% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partisan.R
\name{part_mean_median}
\alias{part_mean_median}
\title{Calculate Mean Median Score}
\usage{
part_mean_median(plans, shp, dvote, rvote)
}
\arguments{
\item{plans}{A \code{redist_plans} object or plans_matrix where each row indicates a district assignment and each column is a plan.}

\item{shp}{A \code{redist_map} object, tibble, or data frame containing other columns.}

\item{dvote}{Unqouted name of column in \code{shp} with total population.}

\item{rvote}{Unqouted name of column in \code{shp} with group population.}
}
\value{
A numeric vector. Can be shaped into a district-by-plan matrix.
}
\description{
Calculate Mean Median Score
}
\examples{
data(nh)
data(nh_m)
# zero for the two district case:
# For a single plan:
part_mean_median(plans = nh$r_2020, shp = nh, rvote = nrv, dvote = ndv)

# Or many plans:
part_mean_median(plans = nh_m[, 3:5], shp = nh, rvote = nrv, dvote = ndv)

}
\references{
Michael D. McDonald and Robin E. Best. 2015.
Unfair Partisan Gerrymanders in Politics and Law: A Diagnostic Applied to Six Cases.
Election Law Journal: Rules, Politics, and Policy. 14. 4. Pp. 312-330.
}
\concept{partisan}
