% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Node.R
\docType{class}
\name{Node-class}
\alias{Node}
\alias{Node-class}
\title{A Redland Node, used to store one node in an RDF triple statement.}
\description{
A Node represents a RDF Resource, Property, Literal or an RDF blank Node.
}
\section{Slots}{

\describe{
\item{\code{librdf_node}}{A redland node object}
}}
\section{Methods}{

\itemize{
  \item{\code{\link{Node-initialize}}}{: Initialize a Node object.}
  \item{\code{\link{getNodeType}}}{: Determine the node type and return as a string.}
  \item{\code{\link{getBlankNodeId}}}{: Get the blank identifier that has been assigned for a specified Node object.}
}
}
\examples{
world <- new("World")
# a blank node is created with a unique identifier generated by librdf
node <- new("Node", world)
# a blank node is created with a unique identifier generated by librdf
node <- new("Node", world, blank=NULL)
# a blank node is created with the user specified identifier, i.e. "_:id1"
node <- new("Node", world, blank="someid")
# a node type of 'literal' is created
node <- new("Node", world, literal="A Node Value")
# a Node type of 'resource' is created
node <- new("Node", world, uri="http://www.example.com")
}
\seealso{
\code{\link{redland}}{: redland package}
}
\keyword{classes}

