\name{pwcv}
\Rdversion{1.1}
\alias{pwcv}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Pointwise cross-validation for function-on-scalar regression}
\description{
  Estimates prediction error for a function-on-scalar regression model by 
  leave-one-function-out cross-validation (CV), at each of a specified set of points.    
}
\usage{
pwcv(fdobj, Z, L = NULL, lambda, 
     eval.pts=seq(min(fdobj$basis$range), max(fdobj$basis$range),   
                  length.out=201),
     scale = FALSE) 
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{fdobj}{
a functional data object (class \code{fd}) giving the functional responses.}
  \item{Z}{
the model matrix, whose columns represent scalar predictors.}
  \item{L}{
a row vector or matrix of linear contrasts of the coefficient functions, to be restricted to equal zero.}
  \item{lambda}{
smoothing parameter: either a nonnegative scalar or a vector, of length \code{ncol(Z)}, of nonnegative values.}
  \item{eval.pts}{
argument values at which the CV score is to be evaluated.}
  \item{scale}{
logical value or vector determining scaling of the matrix \code{Z} (see \code{\link{scale}}, to which the value of this argument is passed).}
}
\details{
  Integrating the pointwise CV estimate over the function domain yields the 
  \emph{cross-validated integrated squared error}, the standard overall model fit score
  returned by \code{\link{lofocv}}.

It may be desirable to derive the value of \code{lambda} from an appropriate call to \code{\link{fosr}}, as in the example below.  
}
\value{
A vector of the same length as \code{eval.pts} giving the CV scores.}
\references{
Reiss, P. T., Huang, L., and Mennes, M. (2010).  Fast function-on-scalar regression with penalized basis expansions.  \emph{International Journal of Biostatistics}, 6(1), article 28.  Available at \url{http://works.bepress.com/phil_reiss/16/}
}
\author{
Philip Reiss \email{phil.reiss@nyumc.org}}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{fosr}}, \code{\link{lofocv}}
}
\examples{
\dontrun{
require(fda)
# Canadian weather example from Reiss et al. (2010).
# The first two lines are taken from the fRegress.CV help file (package fda)
smallbasis  <- create.fourier.basis(c(0, 365), 25)
tempfd <- smooth.basis(day.5,
          CanadianWeather$dailyAv[,,"Temperature.C"], smallbasis)$fd
  
# Model matrices for "latitude" and "region" models    
Xreg = cbind(1, model.matrix(~factor(CanadianWeather$region)-1))
Xlat = model.matrix(~CanadianWeather$coord[,1])

# Fit each model using fosr() to obtain lambda values for pwcv()
Lreg = matrix(c(0,1,1,1,1), 1)   # constraint for region model
regionmod = fosr(fdobj=tempfd, X=Xreg, con=Lreg, method="OLS")
cv.region = pwcv(tempfd, Xreg, Lreg, regionmod$lambda)

latmod = fosr(fdobj=tempfd, X=Xlat, method="OLS")
cv.lat = pwcv(tempfd, Xlat, lambda=latmod$lambda)

# The following plots may require a wide graphics window to show up correctly
par(mfrow=1:2)
# Plot the functional data
plot(tempfd, col=1, lty=1, axes=list("axesIntervals"), xlab="", ylab="Mean temperature", 
     main="Temperatures at 35 stations")    
box()

# Plot the two models' pointwise CV 
matplot(regionmod$argvals, cbind(cv.region, cv.lat), type='l', col=1, axes=FALSE, 
        xlab="", ylab="MSE.CV", main="Pointwise CV for two models")
legend(250, 40, c('Region', 'Latitude'), lty=1:2)
box()
axis(2)
axisIntervals(1)
}
}
