% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pffr-methods.R
\name{qq.pffr}
\alias{qq.pffr}
\title{QQ plots for pffr model residuals}
\usage{
\method{qq}{pffr}(object, rep = 0, level = 0.9, s.rep = 10,
  type = c("deviance", "pearson", "response"), pch = ".", rl.col = 2,
  rep.col = "gray80", ...)
}
\arguments{
\item{object}{a fitted \code{\link{pffr}}-object}

\item{rep}{How many replicate datasets to generate to simulate quantiles
  of the residual distribution.  \code{0} results in an efficient
  simulation free method for direct calculation, if this is possible for
  the object family.}

\item{level}{If simulation is used for the quantiles, then reference intervals can be provided for the QQ-plot, this specifies the level. 
             0 or less for no intervals, 1 or more to simply plot the QQ plot for each replicate generated.}

\item{s.rep}{how many times to randomize uniform quantiles to data under direct computation.}

\item{type}{what sort of residuals should be plotted?  See
  \code{\link{residuals.gam}}.}

\item{pch}{plot character to use. 19 is good.}

\item{rl.col}{color for the reference line on the plot.}

\item{rep.col}{color for reference bands or replicate reference plots.}

\item{...}{extra graphics parameters to pass to plotting functions.}
}
\description{
This is simply a wrapper for code{\link[mgcv]{qq.gam}()}.
}

