context("Checking as.regexr")

test_that("as.regexr returns a regexr object with regular expression chunks equivalent to concatenated subs",{

    myregex <- "(\\d{0,2}:\\d{2}(?:[:.]\\d+)?)(\\s+(([AP]\\.{0,1}M\\.{0,1})|([ap]\\.{0,1}m\\.{0,1})))"
    
    out <- as.regexr(myregex)
    
    expect_true(is(out, "regexr"))
    expect_true(is(out, "character"))
    expect_true(is(out, "reverse_construct"))
    
    expect_equivalent(as.character(out), paste(subs(out), collapse=""))
    expect_true(is.character(unlist(comments(out))))
    expect_true(length(comments(out)) == length(subs(out)))
})



