% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/subs.R
\name{subs}
\alias{set_subs}
\alias{subs}
\alias{subs<-}
\title{Get/Set Regex Sub-expressions From a regexr Object}
\usage{
subs(x, ...)

subs(x) <- value

set_subs(x, y)
}
\arguments{
\item{x}{A regexr object.}

\item{value}{The comment(s) to assign.}

\item{y}{The sub-expressions to assign.}

\item{\ldots}{Ignored.}
}
\value{
\code{subs} - Returns a list of sub-expressions.

\code{set_subs} - Returns a \code{regexr} object.
}
\description{
\code{subs} - Get the sub-expressions from a \code{regexr} object.

\code{subs<-} - Set the sub-expressions(s) of a \code{regexr} object.

\code{set_subs} - This is a convenience function that sets the
\code{\link[regexr]{subs}} on a \code{regexr} object and returns the object.
}
\examples{
minimal <- construct("a", "b", "c")
minimal
subs(minimal)
subs(minimal)[2] <- "\\\\s+[A-Z]|[0-9]"
subs(minimal)

minimal <- construct("a", "b", "c")
out <- set_subs(minimal, c("(", "\\\\s??", ")"))
subs(out)
}

