% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfpca.R
\name{bfpca}
\alias{bfpca}
\title{Binary functional principal components analysis}
\usage{
bfpca(
  Y,
  npc = 1,
  Kt = 8,
  maxiter = 50,
  t_min = NULL,
  t_max = NULL,
  print.iter = FALSE,
  row_obj = NULL,
  seed = 1988,
  ...
)
}
\arguments{
\item{Y}{Dataframe. Should have variables id, value, index.}

\item{npc}{Default is 1. Number of principal components to calculate.}

\item{Kt}{Number of B-spline basis functions used to estimate mean functions. Default is 8.}

\item{maxiter}{Maximum number of iterations to perform for EM algorithm. Default is 50.}

\item{t_min}{Minimum value to be evaluated on the time domain.}

\item{t_max}{Maximum value to be evaluated on the time domain.}

\item{print.iter}{Prints current error and iteration}

\item{row_obj}{If NULL, the function cleans the data and calculates row indices. 
Keep this NULL if you are using standalone \code{register} function.}

\item{seed}{Set seed for reproducibility. Default is 1988.}

\item{...}{Additional arguments passed to or from other functions}
}
\value{
An object of class \code{fpca} containing:
\item{knots}{Cutpoints for B-spline basis used to rebuild \code{alpha}.}
\item{efunctions}{\eqn{D \times npc} matrix of estimated FPC basis functions.}
\item{evalues}{Estimated variance of the FPC scores.}
\item{npc}{number of FPCs.}
\item{scores}{\eqn{I \times npc} matrix of estimated FPC scores.}
\item{alpha}{Estimated population-level mean.}
\item{mu}{Estimated population-level mean. Same value as \code{alpha} but included for compatibility
with \code{refund.shiny} package.}
\item{subject_coefs}{B-spline basis coefficients used to construct subject-specific means. 
For use in \code{registr()} function.}
\item{Yhat}{FPC approximation of subject-specific means.}
\item{Y}{The observed data.}
\item{family}{\code{binomial}, for compatibility with \code{refund.shiny} package.}
\item{error}{vector containing error for each iteration of the algorithm.}
}
\description{
Function used in the FPCA step for registering binary functional data,
called by \code{\link{register_fpca}} when \code{family = "binomial"}. 
This method uses a variational EM algorithm to estimate scores and principal components for 
binary functional data.
}
\examples{
Y = simulate_functional_data()$Y
bfpca_object = bfpca(Y, npc = 2, print.iter = TRUE)

}
\references{
Jaakkola, T. S. and Jordan, M. I. (1997).
A variational approach to Bayesian logistic regression models and their extensions. 
\emph{Proceedings of the Sixth International Workshop on Artificial Intelligence 
and Statistics}.

Tipping, M. E. (1999). Probabilistic Visualisation of High-dimensional binary data.
\emph{Advances in neural information processing systems}, 592--598.
}
\author{
Julia Wrobel \email{jw3134@cumc.columbia.edu},
Jeff Goldsmith \email{ajg2202@cumc.columbia.edu}
}
