% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss_h_gradient.R
\name{loss_h_gradient}
\alias{loss_h_gradient}
\title{Gradient of loss function for registration step}
\usage{
loss_h_gradient(
  Y,
  Theta_h,
  mean_coefs,
  knots,
  beta.inner,
  family = "gaussian",
  t_min,
  t_max
)
}
\arguments{
\item{Y}{vector of observed points.}

\item{Theta_h}{B-spline basis for inverse warping functions.}

\item{mean_coefs}{spline coefficient vector for mean curve.}

\item{knots}{knot locations for B-spline basis used to estimate mean and FPC basis function.}

\item{beta.inner}{spline coefficient vector to be estimated for warping function h.}

\item{family}{\code{gaussian} or \code{binomial}.}

\item{t_min}{minimum value to be evaluated on the time domain.}

\item{t_max}{maximum value to be evaluated on the time domain.}
}
\value{
A numeric vector of spline coefficients for the gradient of the loss function.
}
\description{
Gradient of loss function for registration step
}
\author{
Julia Wrobel \email{jw3134@cumc.columbia.edu}
}
