% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register_fpca.R
\name{register_fpca}
\alias{register_fpca}
\title{Register curves using constrained optimization and GFPCA}
\usage{
register_fpca(
  Y,
  Kt = 8,
  Kh = 4,
  family = "binomial",
  max_iterations = 10,
  npc = 1,
  ...
)
}
\arguments{
\item{Y}{Dataframe. Should have values id, value, index.}

\item{Kt}{Number of B-spline basis functions used to estimate mean functions. Defaults to 8.}

\item{Kh}{Number of B-spline basis functions used to estimate warping functions \emph{h}. Defaults to 4.}

\item{family}{\code{gaussian} or \code{binomial}.}

\item{max_iterations}{Number of iterations for overall algorithm. Defaults to 10.}

\item{npc}{Number of principal components to calculate. Defaults to 1.}

\item{...}{Additional arguments passed to registr and fpca functions.}
}
\value{
An object of class \code{registration} containing:
\item{fpca_obj}{List of items from FPCA step.}
\item{Y}{The observed data plus variables \code{t_star} and \code{t_hat} which are the
unregistered grid and registered grid, respectively.}
\item{time_warps}{List of time values for each iteration of the algorithm. 
\code{time_warps[1]} is the original (observed) time
and \code{time_warps[n]} provides time values for the nth iteration.}
\item{loss}{Loss for each iteration of the algorithm, calculated in the registration step using an 
exponential family likelihood with natural parameter from the FPCA step.}

family \code{gaussian} or \code{binomial}.
}
\description{
Function combines constrained optimization and FPCA to estimate warping functions for 
exponential family curves. The FPCA step is performed through the function 
\code{\link{bfpca}} if \code{family = "binomial"} or the function 
\code{\link{fpca_gauss}} if \code{family = "gaussian"}. Warping functions are calculated 
by the function \code{\link{registr}}.
}
\details{
Requires input data \code{Y} to be a dataframe in long format with variables 
\code{id}, \code{index}, and \code{value} to indicate subject IDs, times, and observations, 
respectively. The code calls two
}
\examples{


 Y = simulate_unregistered_curves(I = 20, D = 200)
 registr_object = register_fpca(Y, family = "binomial", max_iterations = 5)

\donttest{ 
 # example using accelerometer data from nhanes 2003-2004 study
 data(nhanes)
 register_nhanes = register_fpca(nhanes, npc = 2, family = "binomial", max_iterations = 5)
}

}
\author{
Julia Wrobel \email{jw3134@cumc.columbia.edu}
Jeff Goldsmith \email{ajg2202@cumc.columbia.edu}
}
