% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpca_gauss.R
\name{fpca_gauss_optimization}
\alias{fpca_gauss_optimization}
\title{Internal main optimization for fpca_gauss}
\usage{
fpca_gauss_optimization(
  npc,
  npc_varExplained = NULL,
  Kt,
  maxiter,
  print.iter,
  seed,
  periodic,
  error_thresh,
  verbose,
  Y,
  rows,
  I,
  knots,
  Theta_phi,
  alpha_coefs
)
}
\arguments{
\item{npc}{The number of functional principal components (FPCs)
has to be specified either directly as \code{npc} or based on their explained
share of variance. In the latter case, \code{npc_varExplained} has to be set
to a share between 0 and 1.}

\item{npc_varExplained}{The number of functional principal components (FPCs)
has to be specified either directly as \code{npc} or based on their explained
share of variance. In the latter case, \code{npc_varExplained} has to be set
to a share between 0 and 1.}

\item{Kt}{Number of B-spline basis functions used to estimate mean functions
and functional principal components. Default is 8. If \code{npc_varExplained}
is used, \code{Kt} is set to 20.}

\item{maxiter}{Maximum number of iterations to perform for EM algorithm. Default is 50.}

\item{print.iter}{Prints current error and iteration}

\item{seed}{Set seed for reproducibility. Defaults to 1988.}

\item{periodic}{If TRUE, uses periodic b-spline basis functions. Default is FALSE.}

\item{error_thresh}{Error threshold to end iterations. Defaults to 0.0001.}

\item{verbose}{Can be set to integers between 0 and 4 to control the level of
detail of the printed diagnostic messages. Higher numbers lead to more detailed
messages. Defaults to 1.}

\item{Y, rows, I, knots, Theta_phi, alpha_coefs}{Internal objects created in
\code{fpca_gauss}.}
}
\value{
list with elements \code{t_vec}, \code{Theta_phi_mean}, \code{alpha_coefs},
\code{efunctions}, \code{evalues}, \code{evalues_sum}, \code{scores},
\code{subject_coef}, \code{fittedVals}, \code{sigma2}. See documentation of
\code{\link{fpca_gauss}} for details.
}
\description{
Main optimization function for \code{fpca_gauss}. If \code{npc_varExplained}
is specified, the function simply returns a list with elements \code{npc}
(chosen number of FPCs), \code{evalues} (estimated variances of the first 'npc'
FPCs) and \code{evalues_sum} (sum of the estimated variances of the first 20
FPCs, as approximation of the overall variance).
}
