% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registr-utils.R
\name{initial_params}
\alias{initial_params}
\title{Create initial parameters for (inverse) warping functions}
\usage{
initial_params(warping = "nonparametric", K, t_vec)
}
\arguments{
\item{warping}{If \code{nonparametric} (default), inverse warping functions are estimated nonparametrically. 
If \code{piecewise_linear2} they follow a piecewise linear function with 2 knots.}

\item{K}{Spline basis matrix defined over the interval \code{c(t_min, t_max)}.}

\item{t_vec}{Vector of the observed and potentially irregular time grid.}
}
\description{
Dependent on the specific type of warping functions, this function creates
a vector of initial parameters. For \code{"nonparametric"} warpings that
are based on a given spline basis matrix, the initial parameters are defined
s.t. the resulting (inverse) warping function equals a diagonal line.
For \code{"piecewise_linear2"} warpings a fixed parameter vector is returned.
}
