% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_regmedint_class_user_methods.R
\name{print.regmedint}
\alias{print.regmedint}
\title{print method for regmedint object}
\usage{
\method{print}{regmedint}(
  x,
  a0 = NULL,
  a1 = NULL,
  m_cde = NULL,
  c_cond = NULL,
  args_mreg_fit = list(),
  args_yreg_fit = list(),
  ...
)
}
\arguments{
\item{x}{An object of the \code{\link{regmedint}} class.}

\item{a0}{A numeric vector of length 1}

\item{a1}{A numeric vector of length 1}

\item{m_cde}{A numeric vector of length 1 The mediator value at which the controlled direct effect (CDE) conditional on the adjustment covariates is evaluated. If not provided, the default value supplied to the call to \code{\link{regmedint}} will be used. Only the CDE is affected.}

\item{c_cond}{A numeric vector of the same length as \code{cvar}. A set of covariate values at which the conditional natural effects are evaluated.}

\item{args_mreg_fit}{A named list of argument to be passed to the method for the \code{mreg_fit} object.}

\item{args_yreg_fit}{A named list of argument to be passed to the method for the \code{mreg_fit} object.}

\item{...}{For compatibility with the generic. Ignored.}
}
\value{
Invisibly return the \code{regmedint} class object as is.
}
\description{
Print the \code{mreg_fit}, \code{yreg_fit}, and the mediation analysis effect estimates.
}
\examples{
library(regmedint)
data(vv2015)
regmedint_obj <- regmedint(data = vv2015,
                           ## Variables
                           yvar = "y",
                           avar = "x",
                           mvar = "m",
                           cvar = c("c"),
                           eventvar = "event",
                           ## Values at which effects are evaluated
                           a0 = 0,
                           a1 = 1,
                           m_cde = 1,
                           c_cond = 0.5,
                           ## Model types
                           mreg = "logistic",
                           yreg = "survAFT_weibull",
                           ## Additional specification
                           interaction = TRUE,
                           casecontrol = FALSE)
## Implicit printing
regmedint_obj
## Explicit printing
print(regmedint_obj)
## Evaluate at different values
print(regmedint_obj, m_cde = 0, c_cond = 1)

}
