% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkLogistic.R
\name{CV.NetLogistic}
\alias{CV.NetLogistic}
\title{k-folds cross-validation for network-based logistic regression.}
\usage{
CV.NetLogistic(X, Y, lamb.1 = NULL, lamb.2 = NULL, r = 5, alpha.i = 1,
  folds = 5)
}
\arguments{
\item{X}{a matrix of predictors.}

\item{Y}{a vector of the binary response.}

\item{lamb.1}{a user-supplied sequence of lambda1. Tuning parameter lambda1 imposes sparsity.
If it is left as NULL, a default sequence will be used.}

\item{lamb.2}{a user-supplied sequence of lambda2. Tuning parameter lambda2 controls the smoothness
among coefficient profiles. If it is left as NULL, a default sequence, c(0.1, 1, 10), will be used.}

\item{r}{the regularization parameter in MCP, default is 5.}

\item{alpha.i}{by default, the program use the lasso for choosing initial values of
the coefficient vector. alpha.i is the elastic-net mixing parameter, with \eqn{0 \le alpha.i \le 1}. alpha.i=1 is the
lasso penalty, and alpha.i=0 the ridge penalty. If assign alpha.i to be -1, program will use zero
as initial coefficients.}

\item{folds}{the number of folds for cross-validation, default is 5.}
}
\value{
a list with components:
\item{lambda}{the optimal pair of lambda1 and lambda2.}
\item{mcr}{the misclassification rate of the optimal pair of lambda1 and lambda2.}
\item{MCR}{a matrix of the misclassification rates for all pairs of lambdas tested.}
}
\description{
This function dose k-fold cross-validation for the Network-based logistic regression and returns
a pair of lambda1 and lambda2.
}
\references{
Ren, J., He, T., Li, Y., Liu, S., Du, Y., Jiang, Y., Wu, C. (2017).
Network-based regularization for high dimensional SNP data in the case – control study of
Type 2 diabetes. BMC Genetics.
}
\seealso{
\code{\link{NetLogistic}}
}
