% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{augment_quantile}
\alias{augment_quantile}
\alias{augment_quantile_longer}
\title{Augment data with randomized quantile residuals}
\usage{
augment_quantile(x, ...)

augment_quantile_longer(x, ...)
}
\arguments{
\item{x}{Fitted model to obtain randomized quantile residuals from}

\item{...}{Additional arguments to pass to \code{broom::augment()}}
}
\value{
Data frame with one row per observation used to fit \code{x}, including a
\code{.quantile.resid} column containing the quantile residuals. See
\code{broom::augment()} and its methods for details of other columns.

For \code{augment_quantile_longer()}, the output is in "long" format with one row
per predictor per observation. Columns \code{.predictor_name} and
\code{.predictor_value} identify the predictor and its value. An additional column
\code{.obs} records the original observation numbers so results can be matched to
observations in the original model data. See Limitations in
\code{augment_longer()} for limitations on factor predictors.
}
\description{
Generates a data frame containing a model's predictors, the residuals, and
the randomized quantile residuals as additional columns.
}
\details{
Randomized quantile residuals provide more interpretable residuals for
generalized linear models (GLMs), such as logistic regression. See Dunn and
Smyth (1996) for details, or review the examples provided in
\code{vignette("DHARMa", package="DHARMa")}.

Let \eqn{F_Y(y; x, \beta)} be the predicted cumulative distribution function
for \eqn{Y} when \eqn{X = x}, using the fitted GLM. When the response is
continuous, the randomized quantile residual for observation \eqn{i} is

\deqn{r_{q,i} = F_Y(y_i; x_i, \hat \beta).}

When the response is discrete, let

\deqn{a_i = \lim_{y \uparrow y_i} F_Y(y; x_i, \hat \beta)}

and

\deqn{b_i = F_Y(y_i; x_i, \hat \beta),}

then draw the randomized quantile residual as

\deqn{r_{q,i} \sim \text{Uniform}(a_i, b_i).}{r_{q,i} ~ Uniform(a_i, b_i).}

As cumulative distributions are left-continuous, this "jitters" the values
between the discrete steps, resulting in a residual that is uniformly
distributed when the model is correct.

Some definitions of randomized quantile residuals transform the resulting
values using the standard normal inverse cdf, so they are normally
distributed. That step is omitted here, as uniform residuals are easy to work
with.
}
\section{Implementation details}{
Uses \code{broom::augment()} to generate the data frame, then uses the \href{https://cran.r-project.org/package=DHARMa}{DHARMa package} to generate randomized
quantile residuals for the model.
}

\references{
Dunn, Peter K., and Gordon K. Smyth (1996).
"Randomized Quantile Residuals." \emph{Journal of Computational and Graphical
Statistics} 5 (3): 236–44. \doi{10.2307/1390802}
}
\seealso{
\code{vignette("logistic-regression-diagnostics")} and
\code{vignette("other-glm-diagnostics")} for examples of plotting and
interpreting randomized quantile residuals; \code{\link[=augment_longer]{augment_longer()}};
\code{\link[broom:reexports]{broom::augment()}}
}
