% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.R
\name{lmsel}
\alias{lmsel}
\title{Linear regression with variable selection}
\usage{
lmsel(formula, data=environment(), varsel=FALSE, criterion="AIC",
direction="backward", indices=NULL, train=0.3, lambda=1000)
}
\arguments{
\item{formula}{an object of class "formula"; a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment containg the variables in the model. If not specified, the variables are taken from the current environment.}

\item{varsel}{a method of variable selection to be used. The default is \code{"FALSE"}. Available methods include: stepwise regression \code{"step"}, LASSO \code{"lasso"}, elastic net\code{"enet"}.}

\item{criterion}{when \code{varsel="step", criterion} allows to select a method of calculating statistic for model comparison. The default is  \code{"AIC"}. Less liberal, BIC penalty can be used by typing \code{"BIC"}.}

\item{direction}{the mode of stepwise search, can be one of \code{"both"}, \code{"backward"}, or \code{"forward"}, with a default of \code{"both"}. If the scope argument is missing the default for \code{direction} is \code{"backward"}.}

\item{indices}{vector of \code{0} and \code{1} values indicating which observations are to be used as train and test when \code{varsel="lasso" or "enet"}.}

\item{train}{if \code{indices=NULL}, the function will randomly assign observations as train and test. \code{train} specifies what percentage of data will be used as train observations. Can take values from \code{0.1} to \code{0.9}.}

\item{lambda}{quadratic penalty parameter for elastic net. The default value is \code{1000}.}
}
\value{
A \code{"lmsel"} object is returned, for which print, plot and summary methods can be used.
}
\description{
\code{lmsel} is used to fit linear models with optionally performing variable selection using stepwise regression, lasso or elastic net methods.
}
\examples{
data(prostate)
set.seed(10)
lmsel(lpsa~lcavol+lweight+age+lbph+svi+lcp+gleason+pgg45, indices=as.numeric(prostate$train),
data=prostate, varsel="lasso")

data(concrete)
lmsel(CompressiveStrength~., data=concrete, varsel="step", criterion="BIC")
}
\author{
Michal Knut \email{1105406k@student.gla.ac.uk}.
}

