% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_weights.R
\name{calculate_weights}
\alias{calculate_weights}
\title{Calculate regression weights}
\usage{
calculate_weights(mod, term)
}
\arguments{
\item{mod}{The linear model object from \code{lm} or \code{lm_robust}.}

\item{term}{String indicating the term for which
to calculate the implicit regression weights. This must uniquely match
a coefficient name (i.e. it must be a string which appears in only one
element of \code{coef(mod)}).}
}
\value{
An object of class \code{regweight} containing:\tabular{ll}{
\code{term} \tab The term in the regression for which weights were calculated. \cr
\tab \cr
\code{model} \tab The partial regression model object. \cr
\tab \cr
\code{weights} \tab The implicit regression weights. \cr
}
}
\description{
Given a model and a term of interest, calculate
the Aronow and Samii (2015) \doi{10.1111/ajps.12185} regression
weights and return an object which can be used to diagnose these
implicit weights.
}
\details{
This calculates the implicit regression weights for a particular term
in a given regression model.

In short, this calculates the weights for a coefficient \eqn{\beta} such that:

\deqn{\frac{\mathrm{E}[w_i \beta_i]}{\mathrm{E}[w_i]} \to \beta}

where \eqn{\beta_i} is the unit level effect. The expectation of \eqn{w_i} is the
conditional variance of the variable of interest.

For details and examples, view the vignette:
\code{vignette("example-usage", package = "regweight")}
}
\examples{
y <- rnorm(100)
a <- rbinom(100, 1, 0.5)
x <- rnorm(100)
m1 <- stats::lm(y ~ a + x)

w1 <- calculate_weights(m1, "a")
}
\references{
Aronow, P.M. and Samii, C. (2016), "Does Regression Produce
Representative Estimates of Causal Effects?". \emph{American Journal of Political
Science}, 60: 250-267. \doi{10.1111/ajps.12185}
}
