% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy.R
\name{makePolicy}
\alias{makePolicy}
\alias{Policy}
\title{Create policy.}
\usage{
makePolicy(class = "random", args = list(), ...)
}
\arguments{
\item{class}{[\code{character(1)}] \cr
Class of policy. One of \code{c("random", "epsilon.greedy", "greedy", "softmax")}.}

\item{args}{[\code{list}] \cr Optional list of named arguments passed on to the
subclass. The arguments in ... take precedence over values in this list.
We strongly encourage you to use one or the other to pass arguments
to the function but not both.}

\item{...}{[\code{any}] \cr Optional named arguments passed on to the subclass. Alternatively
these can be given using the \code{args} argument.}
}
\value{
[\code{list(name, args)}] List with the name and optional args.
This list can then be passed onto \link{makeAgent}, which will construct the
policy accordingly.
}
\description{
Reinforcement learning policies.
}
\section{Policies}{

\itemize{
\item \link{RandomPolicy}
\item \link{GreedyPolicy}
\item \link{EpsilonGreedyPolicy}
\item \link{SoftmaxPolicy}
}
}

\examples{
policy = makePolicy("random")
policy = makePolicy("epsilon.greedy", epsilon = 0.1)
}
