% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remstimate.R
\name{aicc}
\alias{aicc}
\alias{aicc.remstimate}
\title{aicc}
\usage{
aicc(object, ...)

\method{aicc}{remstimate}(object, ...)
}
\arguments{
\item{object}{is a \code{remstimate} object.}

\item{...}{further arguments to be passed to the 'aicc' method.}
}
\value{
AICC value of a 'remstimate' object.
}
\description{
A function that returns the AICC (Akaike's Information Corrected Criterion) value in a 'remstimate' object.
}
\section{Methods (by class)}{
\itemize{
\item \code{aicc(remstimate)}: AICC (Akaike's Information Corrected Criterion) value of a 'remstimate' object

}}
\examples{

# ------------------------------------ #
#       tie-oriented model: "MLE"      #
# ------------------------------------ #

# loading data
data(tie_data)

# processing event sequence with remify
tie_reh <- remify::remify(edgelist = tie_data$edgelist, model = "tie")
  
# specifying linear predictor
tie_model <- ~ 1 + 
               remstats::indegreeSender()+
               remstats::inertia()+
               remstats::reciprocity() 

# calculating statistics
tie_reh_stats <- remstats::remstats(reh = tie_reh, 
                                    tie_effects = tie_model)

# running estimation
tie_mle <- remstimate::remstimate(reh = tie_reh,
                                  stats = tie_reh_stats,
                                  method = "MLE",
                                  ncores = 1)

# AICC
aicc(tie_mle) 

}
