% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydrate.R
\name{hydrate}
\alias{hydrate}
\title{Hydrate a Project}
\usage{
hydrate(
  packages = NULL,
  ...,
  library = NULL,
  update = FALSE,
  sources = NULL,
  project = NULL
)
}
\arguments{
\item{packages}{The set of \R packages to install. When \code{NULL}, the
set of packages as reported by \code{\link[=dependencies]{dependencies()}} is used.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, \code{renv} will signal an error.}

\item{library}{The \R library to be hydrated. When \code{NULL}, the active
library as reported by \code{.libPaths()} is used.}

\item{update}{Boolean; should \code{hydrate()} attempt to update already-installed
packages if the requested package is already installed in the project
library? Set this to \code{"all"} if you'd like \emph{all} packages to be refreshed
from the source library if possible.}

\item{sources}{A set of library paths from which \code{renv} should attempt to
draw packages. See \strong{Sources} for more details.}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
A named \R list, giving the packages that were used for hydration
as well as the set of packages which were not found.
}
\description{
Discover the \R packages used within a project, and then install those
packages into the active library. This effectively allows you to fork the
state of your default \R libraries for use within a project library.
}
\details{
It may occasionally be useful to use \code{renv::hydrate()} to update the packages
used within a project that has already been initialized. However, be warned
that it's possible that the packages pulled in may not actually be compatible
with the packages installed in the project library, so you should exercise
caution when doing so.
}
\section{Sources}{


\code{hydrate()} attempts to re-use packages already installed on your system,
to avoid unnecessary attempts to download and install packages from remote
sources. When \code{NULL} (the default), \code{hydrate()} will attempt to discover \R
packages from the following sources (in order):
\itemize{
\item The user library,
\item The site library,
\item The system library,
\item The \code{renv} cache.
}

If package is discovered in one of these locations, \code{renv} will attempt to
copy or link that package into the requested library as appropriate.
}

\section{Missing Packages}{


If \code{renv} discovers that your project depends on \R packages not currently
installed in your user library, then it will attempt to install those
packages from the active R repositories.
}

\examples{
\dontrun{

# hydrate the active library
renv::hydrate()

}
}
