% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_put}
\alias{repo_put}
\title{Create a new item in the repo.}
\usage{
repo_put(repo, obj, name, description, tags, src = NULL, depends = NULL,
  replace = F, asattach = F, to = NULL, addversion = F)
}
\arguments{
\item{repo}{An object of class repo.}

\item{obj}{An R object to store in the repo.}

\item{name}{A character identifier for the new item.}

\item{description}{A character description of the item.}

\item{tags}{A list of tags to sort the item. Tags are useful for
selecting sets of items and run bulk actions.}

\item{src}{The item's provenance as a list of character. Usually
the name of the script producing the stored object, a website where
the object was downloaded, and so on. If one of the provenance
strings matches the name of a repo's item, this will create a
dependency link.}

\item{depends}{The name of an item on which this item depends.}

\item{replace}{If the item exists, overwrite the specified fields.}

\item{asattach}{Specifies that the item is to be trated as an
attachment (see attach).}

\item{to}{Optionally specifies which item this item is attached to.}

\item{addversion}{If TRUE and an item named name exists, create a
new version of the same item.}
}
\value{
Used for side effects.
}
\description{
Given an R object, stores it to an RDS file in the \code{repo} root
and add an associated item to the \code{repo} index, including
object name, description, tags and more.
}
\details{
The item \code{name} can be any string, however it should
be a concise identifier, possibly without special character (could
become mandatory soon). Some tags have a special meaning, like
"hide" (do not show the item by default), "attachment" (the item is
an attachment - this should never be set manually), "stash" (the
item is a stashed item, makes the item over-writable by other
"stash" items by default).
}
\examples{
## Repository creation (or opening, if exists)
repo_path <- file.path(tempdir(), "example_repo")
repo <- repo_open(repo_path, TRUE)

## As provenance string we will use the fully  name
## of the file containing this script. Use "normalizePath"
## for fully qualified name (causes problems if used in
## the example).

src <- "repoS3.R"

## Producing some irrelevant data
data1 <- 1:10
data2 <- data1 * 2
data3 <- data1 / 2

## Putting the data in the database, specifying dependencies
repo$put(
    obj = data1,
    name = "item1",
    description = "First item",
    tags = c("repo_put", "a_random_tag"),
    src = src,
    replace=TRUE
    )
repo$put(data2, "item2", "Item dependent on item1",
    "repo_dependencies", src, "item1", replace=TRUE)
repo$put(data3, "item3", "Item dependent on item1 and item2",
    "repo_dependencies", src, c("item1", "item2"), replace=TRUE)

print(repo)

## Creating another version of item1
data1.2 <- data1 + runif(10)
repo$put(data1.2, name = "item1", "First item with additional noise",
    tags = c("repo_put", "a_random_tag"), src, addversion=TRUE)
print(repo, all=TRUE)
repo$info("item1#1")

## wiping temporary repo
unlink(repo_path, TRUE)
}

