% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_factory.R
\name{validate_factory}
\alias{validate_factory}
\title{Inspect and validate the content of a factory}
\usage{
validate_factory(factory = ".")
}
\arguments{
\item{factory}{The path to the report factory or a folder within the desired
factory. Defaults to the current directory.}
}
\value{
A list with 4 entries:
\itemize{
\item root - the root folder path of the factory;
\item factory_name - the name of the report factory;
\item report_sources - the name of the report_sources folder; and
\item outputs - the name of the outputs folder.
}
}
\description{
\code{validate_factory()} can be used to inspect the content of a factory and make
everything looks fine. This includes various sanity checks listed in details
that will error if a problem is found.
}
\details{
Checks run on the factory include:
\itemize{
\item the factory directory exists;
\item the factory_config file exist;
\item all mandatory folders exist - by default these are 'report_sources/'
and 'outputs/';
}
}
