% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{CalculateTheoreticalEffectSizes}
\alias{CalculateTheoreticalEffectSizes}
\title{CalculateTheoreticalEffectSizes}
\usage{
CalculateTheoreticalEffectSizes(mean, std, type = "n")
}
\arguments{
\item{mean}{The theoretical central location parameter for the distribution specified by the type parameter.}

\item{std}{The theoretical spread parameter for the distribution specified by the type parameter.}

\item{type}{String identifying the distribution, "n" for normal, "ln" for lognormal, "lap" for Laplace, "g" for Gamm}
}
\value{
dataframe containing the expected standardized effect size, mean, variance,skewness and kurtosis statistics for samples from the specifie distribution
}
\description{
This function constructs the theoretical effect sizes and distribution statistics four (normal, lognormal, Laplace & gamma) given specific parameter values for the distributions
}
\examples{
CalculateTheoreticalEffectSizes(mean=0, std=1, type="l")
# A tibble: 1 x 5
#   RawMean RawVariance RawEffectSize RawSkewness RawKurtosis
#     <dbl>       <dbl>         <dbl>       <dbl>       <dbl>
# 1    1.65        4.67         0.763        6.18        88.5
CalculateTheoreticalEffectSizes(mean=0, std=1, type="n")
#A tibble: 1 x 5
#  RawMean RawVariance RawEffectSize RawSkewness RawKurtosis
#    <dbl>       <dbl>         <dbl>       <dbl>       <dbl>
#1       0           1             0           0           3
}
\author{
Barbara Kitchenham and Lech Madeyski
}
