% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{Kendalltaupb}
\alias{Kendalltaupb}
\title{Kendalltaupb}
\usage{
Kendalltaupb(x, y = NULL, alpha = 0.05)
}
\arguments{
\item{x}{either a matrix with two columns containg two correlated variables or a vector of variables}

\item{y}{if y=NULL, assume x is a matrix with two columns, otherwise y is a vector of variables with x[i] and x[i] being from the same experimental unit}

\item{alpha}{= 0.05, the Type 1 error level used for statistical tests}
}
\value{
list containing the estimate of Kendall's tau, it hypothesis testing variance, and the t-test value obtained from it, the significance of the t-test, the consistent variance of tau and its confidence intervals based on both the normal dstribution and the t-test (recommended by Long and Cliff)
}
\description{
Computes point bi-serial version of Kendall's tau plus a 1-alpha confidence interval using the method recommended by Long and Cliff (1997).  The algorithm is based on Wilcox's code but was extended to return the consistent variance and the confidence intervals based on the t-distribution. Also added a Diagnostic parameter to output internal calculations.
}
\examples{
x=c(1.2,3,1.8,2,2,0.5,0.5,1,3,1)
y=c(1,1,1,1,1,0,0,0,0,0)
Kendalltaupb(x,y,alpha=.05)
# $cor
# [1] 0.3555556
# $ci
# [1] -0.04198026  0.55555556
# $cit
# [1] -0.1240567  0.5555556
# $test
# [1] 1.431084
# $sqse
# [1] 0.0617284
# $consistentvar
# [1] 0.04113925
# $siglevel
# [1] 0.1524063
}
\author{
Rand Wilcox, Barbara Kitchenham and Lech Madeyski
}
