% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packages.R
\name{.installPackages}
\alias{.installPackages}
\title{Internal function to install packages}
\usage{
.installPackages(packages, repos = getOption("repos"),
  githubPkgs = character(0), githubPkgNames, nonLibPathPkgs = character(0),
  install_githubArgs, install.packagesArgs = list(),
  libPath = .libPaths()[1], standAlone = standAlone, forget = FALSE)
}
\arguments{
\item{packages}{Character vector of packages to install via
\code{install.packages}, then load (i.e., with \code{library}). If it is
one package, it can be unquoted (as in \code{require})}

\item{repos}{The remote repository (e.g., a CRAN mirror), passed to \code{install.packages},}

\item{githubPkgs}{Character vector of github repositories and packages, in the
form \code{repository/package@branch}, with branch being optional.}

\item{githubPkgNames}{Character vector of the package names, i.e., just the R package name.}

\item{nonLibPathPkgs}{Character vector of all installed packages that are in \code{.libPaths},
but not in \code{libPath}. This would normally include a listing of
base packages, but may also include other library paths if
\code{standAlone} if \code{FALSE}}

\item{install_githubArgs}{List of optional named arguments, passed to install_github}

\item{install.packagesArgs}{List of optional named arguments, passed to install.packages}

\item{libPath}{The library path where all packages should be installed, and looked for to load
(i.e., call \code{library})}

\item{standAlone}{Logical. If \code{TRUE}, all packages will be installed and loaded strictly
from the \code{libPaths} only. If \code{FALSE}, all \code{.libPaths} will
be used to find the correct versions. This can be create dramatically faster
installs if the user has a substantial number of the packages already in their
personal library. In the case of \code{TRUE}, there will be a hidden file
place in the \code{libPath} directory that lists all the packages
that were needed during the \code{Require} call. Default \code{FALSE} to
minimize package installing.}

\item{forget}{Internally, this function identifies package dependencies using a memoised
function for speed on reuse. But, it may be inaccurate in some cases,
if packages were installed manually by a user. Set this to \code{TRUE} to
refresh that dependency calculation.}
}
\description{
Internal function to install packages
}
\examples{
\dontrun{
  .installPackages("crayon")
}
}
