% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consistentPaths.R
\docType{methods}
\name{normPath}
\alias{normPath}
\alias{normPath,character-method}
\alias{normPath,list-method}
\alias{normPath,NULL-method}
\alias{normPath,missing-method}
\title{Normalize filepath}
\usage{
normPath(path)

\S4method{normPath}{character}(path)

\S4method{normPath}{list}(path)

\S4method{normPath}{`NULL`}(path)

\S4method{normPath}{missing}()
}
\arguments{
\item{path}{A character vector of filepaths.}
}
\value{
Character vector of cleaned up filepaths.
}
\description{
Checks the specified filepath for formatting consistencies:
 1) use slash instead of backslash;
 2) do tilde etc. expansion;
 3) remove trailing slash.
}
\examples{
## normalize file paths
paths <- list("./aaa/zzz",
              "./aaa/zzz/",
              ".//aaa//zzz",
              ".//aaa//zzz/",
              ".\\\\aaa\\\\zzz",
              ".\\\\aaa\\\\zzz\\\\",
              file.path(".", "aaa", "zzz"))

checked <- normPath(paths)
length(unique(checked)) ## 1; all of the above are equivalent

## check to see if a path exists
tmpdir <- file.path(tempdir(), "example_checkPath")

dir.exists(tmpdir) ## FALSE
tryCatch(checkPath(tmpdir, create = FALSE), error = function(e) FALSE) ## FALSE

checkPath(tmpdir, create = TRUE)
dir.exists(tmpdir) ## TRUE

unlink(tmpdir, recursive = TRUE)
}
