% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postProcess.R
\name{assessDataType}
\alias{assessDataType}
\alias{assessDataType.Raster}
\alias{assessDataType.RasterStack}
\alias{assessDataType.default}
\alias{assessDataTypeGDAL}
\title{Assess the appropriate raster layer data type}
\usage{
assessDataType(ras, type = "writeRaster")

\method{assessDataType}{Raster}(ras, type = "writeRaster")

\method{assessDataType}{RasterStack}(ras, type = "writeRaster")

\method{assessDataType}{default}(ras, type = "writeRaster")

assessDataTypeGDAL(ras)
}
\arguments{
\item{ras}{The RasterLayer or RasterStack for which data type will be assessed.}

\item{type}{Character. \code{"writeRaster"} (default) or \code{"GDAL"} to return the recommended
data type for writing from the raster packages, respectively, or
\code{"projectRaster"} to return recommended resampling type.}
}
\value{
A character string indicating the data type of the spatial layer
(e.g., "INT2U"). See \code{\link[terra:geomtype]{terra::datatype()}} or \code{\link[raster:dataType]{raster::dataType()}}
}
\description{
When writing raster-type objects to disk, a \code{datatype} can be specified. These
functions help identify what smallest \code{datatype} can be used.
}
\examples{
## LOG1S
library(raster)
ras <- raster(ncol = 10, nrow = 10)
ras[] <- rep(c(0,1),50)
assessDataType(ras)

ras[] <- rep(c(TRUE,FALSE),50)
assessDataType(ras)

ras[] <- c(NA, NA, rep(c(0,1),49))
assessDataType(ras)

ras <- raster(ncol = 10, nrow = 10)
ras[] <- c(0, NaN, rep(c(0,1),49))
assessDataType(ras)


## INT1S
ras[] <- -1:98
assessDataType(ras)

ras[] <- c(NA, -1:97)
assessDataType(ras)

## INT1U
ras <- raster(ncol = 10, nrow = 10)
ras[] <- 1:100
assessDataType(ras)

ras[] <- c(NA, 2:100)
assessDataType(ras)

## INT2U
ras <- raster(ncol = 10, nrow = 10)
ras[] <- round(runif(100, min = 64000, max = 65000))
assessDataType(ras)

## INT2S
ras <- raster(ncol = 10, nrow = 10)
ras[] <- round(runif(100, min = -32767, max = 32767))
assessDataType(ras)

ras[54] <- NA
assessDataType(ras)

## INT4U
ras <- raster(ncol = 10, nrow = 10)
ras[] <- round(runif(100, min = 0, max = 500000000))
assessDataType(ras)

ras[14] <- NA
assessDataType(ras)

## INT4S
ras <- raster(ncol = 10, nrow = 10)
ras[] <- round(runif(100, min = -200000000, max = 200000000))
assessDataType(ras)

ras[14] <- NA
assessDataType(ras)

## FLT4S
ras <- raster(ncol = 10, nrow = 10)
ras[] <- runif(100, min = -10, max = 87)
assessDataType(ras)

ras <- raster(ncol = 10, nrow = 10)
ras[] <- round(runif(100, min = -3.4e+26, max = 3.4e+28))
assessDataType(ras)

ras <- raster(ncol = 10, nrow = 10)
ras[] <- round(runif(100, min = 3.4e+26, max = 3.4e+28))
assessDataType(ras)

ras <- raster(ncol = 10, nrow = 10)
ras[] <- round(runif(100, min = -3.4e+26, max = -1))
assessDataType(ras)

## FLT8S
ras <- raster(ncol = 10, nrow = 10)
ras[] <- c(-Inf, 1, rep(c(0,1),49))
assessDataType(ras)

ras <- raster(ncol = 10, nrow = 10)
ras[] <- c(Inf, 1, rep(c(0,1),49))
assessDataType(ras)

ras <- raster(ncol = 10, nrow = 10)
ras[] <- round(runif(100, min = -1.7e+30, max = 1.7e+308))
assessDataType(ras)

ras <- raster(ncol = 10, nrow = 10)
ras[] <- round(runif(100, min = 1.7e+30, max = 1.7e+308))
assessDataType(ras)

ras <- raster(ncol = 10, nrow = 10)
ras[] <- round(runif(100, min = -1.7e+308, max = -1))
assessDataType(ras)

# stack
ras <- raster(ncol = 10, nrow = 10)
ras[] <- rep(c(0,1),50)
ras1 <- raster(ncol = 10, nrow = 10)
ras1[] <- round(runif(100, min = -1.7e+308, max = -1))
sta <- stack(ras, ras1)
assessDataType(sta)
}
\author{
Eliot McIntire, Ceres Barros, Ian Eddy, and Tati Micheletti
}
