% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pplscv_cpp}
\alias{pplscv_cpp}
\title{Internal Cpp function for performing leave-group-out cross validations for pls regression}
\usage{
pplscv_cpp(X, Y, scale, method, 
                  mindices, pindices, 
                  minF, ncomp, 
                  newX, 
                  maxiter, tol, 
                  waplsgrid)
}
\arguments{
\item{X}{a \code{matrix} of predictor variables.}

\item{Y}{a \code{matrix} of a single response variable.}

\item{scale}{a logical indicating whether the matrix of predictors (\code{X}) must be scaled.}

\item{method}{the method used for regression. One of the following options: \code{'pls'} or \code{'wapls1'} or \code{'completewapls1p'}.}

\item{mindices}{a \code{matrix} with \code{n} rows and \code{m} columns where \code{m} is equivalent to the number of 
resampling iterations. The elements of each column indicate the indices of the samples to be used for modeling at each 
iteration.}

\item{pindices}{a \code{matrix} with \code{k} rows and \code{m} columns where \code{m} is equivalent to the number of 
resampling iterations. The elements of each column indicate the indices of the samples to be used for predicting at each 
iteration.}

\item{minF}{an integer indicating the number of minimum pls components (if the \code{method = 'pls'}).}

\item{ncomp}{an integer indicating the number of pls components.}

\item{newX}{a \code{matrix} of one row corresponding to the sample to be predicted (if the \code{method = 'wapls1'}).}

\item{maxiter}{maximum number of iterations.}

\item{tol}{limit for convergence of the algorithm in the nipals algorithm.}

\item{waplsgrid}{the grid on which the search for the best combination of minimum and maximum pls factors of \code{'wapls1'} is based on in case \code{method = 'completewapls1p'}.}
}
\value{
a list containing the following one-row matrices:
\itemize{
\item{\code{rmse.seg}}{ the RMSEs.}
\item{\code{st.rmse.seg}}{ the standardized RMSEs.}
\item{\code{rsq.seg}}{ the coefficients of determination.}
}
}
\description{
For internal use only!.
}
\author{
Leonardo Ramirez-Lopez
}
\keyword{internal}

