% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sdp_supply.R
\name{sdp_supply}
\alias{sdp_supply}
\title{Stochastic Dynamic Programming for water supply reservoirs}
\usage{
sdp_supply(Q, capacity, target, surface_area, max_depth, evap, S_disc = 1000,
  R_disc = 10, Q_disc = c(0, 0.2375, 0.475, 0.7125, 0.95, 1),
  loss_exp = 2, S_initial = 1, plot = TRUE, tol = 0.99,
  Markov = FALSE, rep_rrv = FALSE)
}
\arguments{
\item{Q}{vector or time series object. Net inflow totals to the reservoir. Recommended units: Mm^3 (Million cubic meters).}

\item{capacity}{numerical. The reservoir storage capacity. Recommended units: Mm^3 (Million cubic meters).}

\item{target}{numerical. The target release constant. Recommended units: Mm^3 (Million cubic meters).}

\item{surface_area}{numerical. The reservoir water surface area at maximum capacity. Recommended units: km^2 (square kilometers).}

\item{max_depth}{numerical. The maximum water depth of the reservoir at maximum capacity. If omitted, the depth-storage-area relationship will be estimated from surface area and capacity only. Recommended units: meters.}

\item{evap}{vector or time series object of length Q, or a numerical constant.  Evaporation from losses from reservoir surface. Varies with level if depth and surface_area parameters are specified. Recommended units: meters, or kg/m2 * 10 ^ -3.}

\item{S_disc}{integer. Storage discretization--the number of equally-sized storage states. Default = 1000.}

\item{R_disc}{integer. Release discretization. Default = 10 divisions.}

\item{Q_disc}{vector. Inflow discretization bounding quantiles. Defaults to five inflow classes bounded by quantile vector c(0.0, 0.2375, 0.4750, 0.7125, 0.95, 1.0).}

\item{loss_exp}{numeric. The exponent of the penalty cost function--i.e., Cost[t] <- ((target - release[t]) / target) ^ **loss_exp**). Default value is 2.}

\item{S_initial}{numeric. The initial storage as a ratio of capacity (0 <= S_initial <= 1). The default value is 1.}

\item{plot}{logical. If TRUE (the default) the storage behavior diagram and release time series are plotted.}

\item{tol}{numerical. The tolerance for policy convergence. The default value is 0.990.}

\item{Markov}{logical. If TRUE the current period inflow is used as a hydrological state variable and inflow persistence is incorporated using a first-order, periodic Markov chain. The default is FALSE.}

\item{rep_rrv}{logical. If TRUE then reliability, resilience and vulnerability metrics are computed and returned.}
}
\value{
Returns a list that includes: the optimal policy as an array of release decisions dependent on storage state, month/season, and current-period inflow class; the Bellman cost function based on storage state, month/season, and inflow class; the optimized release and storage time series through the training inflow data; the flow discretization (which is required if the output is to be implemented in the rrv function); and, if requested, the reliability, resilience, and vulnerability of the system under the optimized policy.
}
\description{
Derives the optimal release policy based on storage state and within-year period only.
}
\examples{
\donttest{layout(1:3)
sdp_supply(resX$Q_Mm3, capacity = resX$cap_Mm3, target = 0.3 *mean(resX$Q_Mm3))
sdp_supply(resX$Q_Mm3, capacity = resX$cap_Mm3, target = 0.3 *mean(resX$Q_Mm3), Markov = TRUE)
}
}
\seealso{
\code{\link{dp_supply}} for deterministic Dynamic Programming for water supply reservoirs
}

