% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unit_args.R
\name{unit_args}
\alias{unit_args}
\title{Print examples of unit inputs}
\usage{
unit_args()
}
\value{
A print out to the console of accepted units
}
\description{
This is a basic function with no inputs. It prints to the console the units
that can be used in the functions \code{\link[=convert_DO]{convert_DO()}}, \code{\link[=convert_MR]{convert_MR()}},
\code{\link[=convert_rate]{convert_rate()}}, and \code{\link[=convert_rate.ft]{convert_rate.ft()}}.
}
\details{
Note that some oxygen unit conversions require temperature (\code{t}), salinity
(\code{S}), and atmospheric pressure (\code{P}) to be specified.

Note the difference between percent air saturation (\verb{\%Air}), where air
saturated water is ~100\%, and percent oxygen saturation (\verb{\%Oxy}), where air
saturated water is ~20.946\% \emph{oxygen} saturated. In other words, \verb{\%Oxy = \%Air x 0.20946}.

For most units a fuzzy string matching algorithm is used to accept different
formatting styles. For example, \code{"mg/l"}, \code{"mg/L"}, \code{"mgL-1"}, \code{"mg l-1"},
\code{"mg.l-1"} are all parsed the same.
}
\section{\code{\link[=convert_DO]{convert_DO()}}}{
\subsection{Oxygen concentration or pressure units for \code{from} and \code{to}:}{

Oxygen concentration units. Should use SI units (\code{L} or \code{kg}) for the
denominator.

Do \emph{NOT} require \code{t}, \code{S} and \code{P} for conversions:
\itemize{
\item \code{"mg/L"}, \code{"ug/L"}, \code{"mol/L"}, \code{"mmol/L"}, \code{"umol/L"}, \code{"nmol/L"}, \code{"pmol/L"}
}

Require \code{t}, \code{S} and \code{P} for conversions:
\itemize{
\item \code{"uL/L"}, \code{"mL/L"}, \code{"mm3/L"}, \code{"cm3/L"}, \code{"mg/kg"}, \code{"ug/kg"}, \code{"mol/kg"}, \code{"mmol/kg"}, \code{"umol/kg"},
\code{"nmol/kg"}, \code{"pmol/kg"}, \code{"uL/kg"}, \code{"mL/kg"}, \code{"ppm"} (i.e. parts per
million, equivalent to \code{mg/kg}).
}

Percentage saturations (require \code{t}, \code{S} and \code{P}):

\code{"\%Air"} (i.e. \% Air Saturation), \code{"\%Oxy"} (i.e. \% Oxygen Saturation)

Pressure units (require \code{t}, \code{S} and \code{P}):

\code{"Torr"}, \code{"hPa"}, \code{"kPa"}, \code{"mmHg"}, \code{"inHg"}
}
}

\section{\code{\link[=convert_rate]{convert_rate()}} and \code{\link[=convert_rate.ft]{convert_rate.ft()}}}{
\subsection{Oxygen concentration or pressure units for \code{oxy.unit}:}{

See above.
}

\subsection{Time units for \code{time.unit} or as part of \code{flowrate.unit}:}{
\itemize{
\item \verb{"sec", "min", "hour", "day"}
}
}

\subsection{Volume units for use as part of \code{flowrate.unit} (\code{convert_rate.ft} only):}{

For example, in \code{'ml/min'}, \code{'L/s'}, etc.
\itemize{
\item \code{"uL"}, \code{"mL"}, \code{"L"}
}
}
}

\section{Metabolic rate units}{
\subsection{Combining units for \code{output.unit} in \code{\link[=convert_rate]{convert_rate()}} and}{

\code{\link[=convert_rate.ft]{convert_rate.ft()}}, or for use in \code{\link[=convert_MR]{convert_MR()}}:

Must be in correct order:
\itemize{
\item Absolute rates: \code{Oxygen/Time} e.g. \code{"mg/s"}, \code{"umol/min"}, \code{"mL/h"}
\item Mass-specific rates: \code{Oxygen/Time/Mass} e.g. \code{"mg/s/ug"}, \code{"umol/min/g"},
\code{"mL/h/kg"}
\item Area-specific rates: \code{Oxygen/Time/Area} e.g. \code{"mg/s/mm2"},
\code{"umol/min/cm2"}, \code{"mL/h/m2"}
}

\strong{Oxygen amount units:}
\itemize{
\item \code{"ug"}, \code{"mg"}, \code{"pmol"}, \code{"nmol"}, \code{"umol"}, \code{"mmol"}, \code{"mol"}, \code{"uL"}, \code{"mL"}, \code{"mm3"}, \code{"cm3"}
}

Note \code{"mm3"} and \code{"cm3"} (i.e. \code{cc}) are used in some older publications.
These are equivalent to \code{"uL"} and \code{"mL"} respectively.

\strong{Time units:}
\itemize{
\item \code{"sec"}, \code{"min"}, \code{"hour"}, \code{"day"}
}

\strong{Mass units for mass-specific rates:}
\itemize{
\item \code{"ug"}, \code{"mg"}, \code{"g"}, \code{"kg"}
}

\strong{Area units for area-specific rates:}
\itemize{
\item \code{"mm2"}, \code{"cm2"}, \code{"m2"}, \code{"km2"}
}
}
}

\examples{

# Run the function:
unit_args()
}
